/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.demo.jerseyspring.resources;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.crazyyak.demo.jerseyspring.domain.Account;
import org.crazyyak.demo.jerseyspring.resources.RequestConfig;
import org.crazyyak.dev.common.fine.FineMessage;
import org.crazyyak.dev.common.fine.FineMessageSetBuilder;
import org.crazyyak.dev.common.fine.FineMessageSetImpl;
import org.crazyyak.dev.common.fine.TraitMap;
import org.crazyyak.dev.domain.locality.LatLng;
import org.crazyyak.dev.domain.money.Money;
import org.crazyyak.dev.jackson.test.FreeBird;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

public class ApiResource {
    private RequestConfig requestConfig;

    public ApiResource(RequestConfig requestConfig) {
        this.requestConfig = requestConfig;
    }

    @GET
    @Path(value="/account/{emailAddress}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Account getDefault(@PathParam(value="emailAddress") String emailAddress) {
        return this.requestConfig.getAccountStore().getByEmailAddress(emailAddress);
    }

    @GET
    @Path(value="/date/{date}/month-of-year")
    @Produces(value={"application/json"})
    public int getCurrentDate(@PathParam(value="date") LocalDate localDate) {
        return localDate.getMonthOfYear();
    }

    @GET
    @Path(value="/plain-text")
    @Produces(value={"text/plain"})
    public String getPlainText() {
        String text = "This is plain text.\nThere really isn't much to it.\n\n\t- One Crazy Yak";
        return text;
    }

    @GET
    @Path(value="/free-bird")
    @Produces(value={"application/json"})
    public FreeBird freeBirdBaby() {
        return new FreeBird("string-value", Long.MAX_VALUE, Integer.MIN_VALUE, new LatLng("37.3382030", "-119.7085060"), new Money("19.95"), org.joda.money.Money.parse((String)"USD 99.99"), new LocalTime((Object)"12:32:13"), new LocalDate((Object)"1975-05-06"), new LocalDateTime((Object)"1975-05-06T12:32:13"), new TraitMap(new String[]{"first:yes", "empty-value:", "null-value", "last:ok"}), FineMessage.withText((String)"This message is fine!"), (FineMessageSetImpl)new FineMessageSetBuilder().withText("Hi, my name is Joe!").withTraits("I'm Suzie", new String[]{"girl:true", "boy:false"}).build());
    }
}

