/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.demo.jerseyspring.resources;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.crazyyak.demo.jerseyspring.domain.Account;
import org.crazyyak.demo.jerseyspring.resources.AdminResource;
import org.crazyyak.demo.jerseyspring.resources.ApiResource;
import org.crazyyak.demo.jerseyspring.resources.HomePageModel;
import org.crazyyak.demo.jerseyspring.resources.RequestConfig;
import org.glassfish.jersey.server.mvc.Viewable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.stereotype.Component;

@Path(value="/")
@Resource
@Component
public class RootResource
implements BeanFactoryAware {
    private static final Log log = LogFactory.getLog(RootResource.class);
    private HttpServletRequest servletRequest;
    private HttpServletResponse servletResponse;
    private SecurityContext securityContext;
    private UriInfo uriInfo;
    private HttpHeaders headers;
    private BeanFactory beanFactory;

    public RootResource() {
        log.info((Object)"Root resource loaded.");
    }

    @Context
    public void setServletRequest(HttpServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }

    @Context
    public void setServletResponse(HttpServletResponse servletResponse) {
        this.servletResponse = servletResponse;
    }

    @Context
    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    @Context
    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    @Context
    public void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    public RequestConfig getRequestConfig() {
        return new RequestConfig(this.beanFactory, this.servletRequest, this.servletResponse, this.uriInfo, this.headers, this.securityContext);
    }

    @GET
    @Produces(value={"text/html"})
    public Viewable getDefaultPage() {
        return this.renderHomePage(null);
    }

    @GET
    @Path(value="/signed-out")
    @Produces(value={"text/html"})
    public Viewable getSignedOut() {
        return this.renderHomePage("You have signed out.");
    }

    @GET
    @Path(value="/auth-failed")
    @Produces(value={"text/html"})
    public Viewable authenticationFailed() {
        return this.renderHomePage("You do not have permissions to access this resource.");
    }

    @GET
    @Path(value="/access-denied")
    @Produces(value={"text/html"})
    public Viewable accessDenied() {
        return this.renderHomePage("You do not have permissions to access this resource.");
    }

    private Viewable renderHomePage(String message) {
        RequestConfig requestConfig = this.getRequestConfig();
        Account account = requestConfig.getAccount();
        return new Viewable("/index.jsp", (Object)new HomePageModel(account, message));
    }

    @Path(value="/admin")
    public AdminResource getAdminResource() {
        RequestConfig requestConfig = this.getRequestConfig();
        return new AdminResource(requestConfig);
    }

    @Path(value="/api")
    public ApiResource getApiResource() {
        RequestConfig requestConfig = this.getRequestConfig();
        return new ApiResource(requestConfig);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

