package org.crazyyak.demo.jerseyspring.internal;

import org.apache.commons.logging.*;
import org.crazyyak.dev.jerseyspring.YakExceptionMapper;
import org.crazyyak.dev.jerseyspring.YakJspMvcFeature;
import org.crazyyak.dev.jerseyspring.jackson.JodaParamConverterProvider;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ResourceConfig;

public class DemoApplication extends ResourceConfig {

  private static final Log log = LogFactory.getLog(DemoApplication.class);

  public DemoApplication() {

    log.info("Demo application loaded.");

    property(YakJspMvcFeature.SUPPORTED_EXTENSIONS, "jsp, jspf");

    register(MultiPartFeature.class);
    register(YakJspMvcFeature.class);
    register(YakExceptionMapper.class);
    register(JodaParamConverterProvider.class);
    register(DemoReaderWriterProvider.class);

    packages("org.crazyyak.demo.jerseyspring");
  }
}
