package org.crazyyak.demo.jerseyspring.internal;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;

import org.crazyyak.demo.jerseyspring.domain.Account;
import org.crazyyak.dev.jackson.YakJacksonObjectMapper;
import org.crazyyak.dev.jackson.test.FreeBird;
import org.crazyyak.dev.jerseyspring.jackson.JacksonReaderWriterProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Provider
public class DemoReaderWriterProvider extends JacksonReaderWriterProvider {

  @Autowired
  public DemoReaderWriterProvider(YakJacksonObjectMapper objectMapper) {
    super(objectMapper, MediaType.APPLICATION_JSON_TYPE);

    supportedTypes.add(Account.class);
    supportedTypes.add(FreeBird.class);

  }
}
