// Copyright (c) 2010-2013, Munchie Monster, LLC.
package org.crazyyak.demo.jerseyspring.resources;

import javax.ws.rs.*;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.crazyyak.demo.jerseyspring.domain.Account;
import org.crazyyak.dev.common.IoUtils;
import org.glassfish.jersey.server.mvc.Viewable;

import java.io.InputStream;
import java.net.URL;

public class AdminResource {

  private RequestConfig config;

  public AdminResource(RequestConfig config) {
    this.config = config;
  }

  @GET
  @Produces(MediaType.TEXT_HTML)
  public Viewable getDefault() {
    Account account = config.getAccount();
    AdminPageModel model = new AdminPageModel(account);
    return new Viewable("/admin/admin.jsp", model);
  }
}
