// Copyright (c) 2010-2013, Munchie Monster, LLC.
package org.crazyyak.demo.common.app;

import org.crazyyak.demo.common.app.domain.Account;
import org.crazyyak.demo.common.app.domain.AccountStore;
import org.crazyyak.dev.common.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;

@Component
public class DemoCommonSecurityProvider extends AbstractUserDetailsAuthenticationProvider {

  private final AccountStore accountStore;

  @Autowired
  public DemoCommonSecurityProvider(AccountStore accountStore) {
    this.accountStore = accountStore;
  }

  @Override
  protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {

    if (BeanUtils.objectsNotEqual(userDetails.getUsername(), authentication.getPrincipal())) {
      throw new UsernameNotFoundException(Account.INVALID_USER_NAME_OR_PASSWORD);
    }

    if (BeanUtils.objectsNotEqual(userDetails.getPassword(), authentication.getCredentials())) {
      throw new BadCredentialsException(Account.INVALID_USER_NAME_OR_PASSWORD);
    }
  }

  @Override
  protected UserDetails retrieveUser(String userName, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {

    // We use an email address for the user name and
    // thus the disconnect between Account & UserDetails
    Account account = accountStore.getByEmailAddress(userName);

    if (account == null || BeanUtils.objectsNotEqual(account.getEmailAddress(), userName)) {
      throw new UsernameNotFoundException(Account.INVALID_USER_NAME_OR_PASSWORD);
    }

    return account.toUser();
  }
}
