package org.crazyyak.demo.common.app;

import com.couchace.core.api.CouchDatabase;
import com.couchace.core.api.response.WriteResponse;
import java.io.IOException;
import java.util.*;
import javax.annotation.PostConstruct;
import org.crazyyak.dev.common.IoUtils;
import org.crazyyak.dev.common.exceptions.ApiException;
import org.crazyyak.dev.common.id.uuid.TimeUuid;
import org.crazyyak.dev.couchace.DefaultCouchServer;
import org.crazyyak.dev.couchace.support.CouchUtils;
import org.springframework.beans.factory.annotation.*;
import org.springframework.stereotype.Component;

@Component
public class DemoCouchServer extends DefaultCouchServer {

  private final String databaseName;
  private final List<String> designNames = Arrays.asList("account");
  private final String prefix = "/yak-demo-common-app/json/";
  private final String suffix = "-design.json";

  @Autowired
  public DemoCouchServer(@Value("${couchdb.name}") String databaseName) {
    this.databaseName = databaseName;
  }

  public CouchDatabase database() {
    return super.database(databaseName);
  }

  @PostConstruct
  public void validateDatabases() throws IOException {
    CouchDatabase database = database();

    if (database.exists() == false) {
      WriteResponse response = database.createDatabase();
      if (response.isCreated() == false) {
        String msg = String.format("Unable to create database: %s %s", response.getStatusCode().getCode(), response.getStatusCode().getReason());
        throw ApiException.internalServerError(msg);
      }

      String json = IoUtils.toString(getClass().getResourceAsStream("/yak-demo-common-app/json/account.json"));
      response = database.put().document(TimeUuid.randomUUID().toString(), json).execute();
      if (response.isCreated() == false) {
        String msg = String.format("Unable to put document: %s %s", response.getStatusCode().getCode(), response.getStatusCode().getReason());
        throw ApiException.internalServerError(msg);
      }
    }

    CouchUtils.validateDesign(database, designNames, prefix, suffix);
  }

  public String getDatabaseName() {
    return databaseName;
  }

  public List<String> getDesignNames() {
    return designNames;
  }

  public String getPrefix() {
    return prefix;
  }

  public String getSuffix() {
    return suffix;
  }
}
