package org.crazyyak.demo.common.app.domain;

import java.util.List;
import org.crazyyak.demo.common.app.DemoCouchServer;
import org.crazyyak.dev.couchace.DefaultCouchStore;
import org.springframework.beans.factory.annotation.*;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class AccountStore extends DefaultCouchStore<Account> {

  public static final String ACCOUNT_DESIGN_NAME = "account";

  @Autowired
  public AccountStore(DemoCouchServer couchServer, @Value("${couchdb.name}") String databaseName) {
    super(couchServer, databaseName, Account.class);
  }

  @Override
  public String getDesignName() {
    return ACCOUNT_DESIGN_NAME;
  }

  public List<Account> getAll() {
    return super.getEntities("allAccounts");
  }

  public Account getByEmailAddress(String emailAddress) {
    if (emailAddress == null) return null;
    List<Account> response = super.getEntities("byEmailAddress", emailAddress);
    return response.isEmpty() ? null : response.get(0);
  }

  public Account get(CurrentUser currentUser) {
    if (currentUser == null) return null;
    String documentId = currentUser.getAccountId();
    return super.getByDocumentId(documentId);
  }

  public CurrentUser getCurrentUser() {
    Authentication auth = SecurityContextHolder.getContext().getAuthentication();

    if (auth != null) {
      Object principal = auth.getPrincipal();
      if (principal instanceof CurrentUser) {
        return (CurrentUser)principal;
      }
    }

    return null;
  }

  public Account getCurrentAccount() {
    CurrentUser currentUser = getCurrentUser();
    return get(currentUser);
  }
}
