package org.crazyyak.demo.common.app;

import org.apache.commons.logging.*;
import org.crazyyak.demo.common.app.domain.AccountStore;
import org.crazyyak.dev.jackson.YakJacksonObjectMapper;
import org.crazyyak.dev.security.domain.CurrentUserStore;
import org.crazyyak.dev.security.providers.*;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.*;

@Configuration
@ComponentScan(value={"org.crazyyak.demo.common.app"})
public class DemoCommonSpringConfig {

  public static final Log log = LogFactory.getLog(DemoCommonSpringConfig.class);

  public DemoCommonSpringConfig() {
    log.debug("Created " + getClass().getName());
  }

  @Bean
  public YakJacksonObjectMapper yakJacksonObjectMapper() {
    return new YakJacksonObjectMapper();
  }

  @Bean
  public CurrentUserSecurityProvider currentUserSecurityProvider(CurrentUserStore store) {
    return new CurrentUserSecurityProvider(store);
  }

  @Bean
  public GooglePlusSecurityProvider googlePlusSecurityProvider(
      AccountStore accountStore,
      YakJacksonObjectMapper objectMapper,
      @Value("${google.auth.clientId}") String clientId,
      @Value("${google.auth.clientSecret}") String clientSecret) {

    return new GooglePlusSecurityProvider(accountStore, objectMapper, clientId, clientSecret);
  }

}
