package org.crazyyak.demo.common.app;

import com.couchace.core.api.CouchDatabase;
import java.io.IOException;
import java.util.*;
import javax.annotation.PostConstruct;
import org.crazyyak.dev.common.id.TimeUuidIdGenerator;
import org.crazyyak.dev.couchace.DefaultCouchServer;
import org.crazyyak.dev.couchace.support.CouchUtils;
import org.springframework.beans.factory.annotation.*;
import org.springframework.stereotype.Component;

@Component
public class DemoCouchServer extends DefaultCouchServer {

  private final String databaseName;
  private final List<String> designNames = Arrays.asList("account");
  private final String prefix = "/yak-demo-common-app/json/";
  private final String suffix = "-design.json";

  @Autowired
  public DemoCouchServer(@Value("${couchdb.name}") String databaseName) {
    this.databaseName = databaseName;
  }

  public CouchDatabase database() {
    return super.database(databaseName);
  }

  @PostConstruct
  public void validateDatabases() throws IOException {
    CouchDatabase database = database();

    CouchUtils.createDatabase(database, new TimeUuidIdGenerator(),
        "/yak-demo-common-app/json/account-load-yak.json",
        "/yak-demo-common-app/json/account-load-jdp.json");
    CouchUtils.validateDesign(database, designNames, prefix, suffix);
  }

  public String getDatabaseName() {
    return databaseName;
  }

  public List<String> getDesignNames() {
    return designNames;
  }

  public String getPrefix() {
    return prefix;
  }

  public String getSuffix() {
    return suffix;
  }
}
