/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.demo.common.app;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.crazyyak.demo.common.app.domain.AccountStore;
import org.crazyyak.dev.jackson.YakJacksonObjectMapper;
import org.crazyyak.dev.security.domain.CurrentUserStore;
import org.crazyyak.dev.security.providers.CurrentUserSecurityProvider;
import org.crazyyak.dev.security.providers.GooglePlusSecurityProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(value={"org.crazyyak.demo.common.app"})
public class DemoCommonSpringConfig {
    public static final Log log = LogFactory.getLog(DemoCommonSpringConfig.class);

    public DemoCommonSpringConfig() {
        log.debug((Object)("Created " + this.getClass().getName()));
    }

    @Bean
    public YakJacksonObjectMapper yakJacksonObjectMapper() {
        return new YakJacksonObjectMapper();
    }

    @Bean
    public CurrentUserSecurityProvider currentUserSecurityProvider(CurrentUserStore store) {
        return new CurrentUserSecurityProvider(store);
    }

    @Bean
    public GooglePlusSecurityProvider googlePlusSecurityProvider(AccountStore accountStore, YakJacksonObjectMapper objectMapper, @Value(value="${google.auth.clientId}") String clientId, @Value(value="${google.auth.clientSecret}") String clientSecret) {
        return new GooglePlusSecurityProvider((CurrentUserStore)accountStore, (ObjectMapper)objectMapper, clientId, clientSecret);
    }
}

