/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.demo.common.app.domain;

import com.couchace.annotations.CouchEntity;
import com.couchace.annotations.CouchId;
import com.couchace.annotations.CouchRevision;
import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.Set;
import org.crazyyak.dev.security.domain.AccountStatus;
import org.crazyyak.dev.security.domain.CurrentUser;
import org.crazyyak.dev.security.domain.CurrentUserSource;
import org.crazyyak.dev.security.domain.Permissions;

@CouchEntity(value="account")
public class Account
implements CurrentUserSource {
    public static final String INVALID_USER_NAME_OR_PASSWORD = "Invalid user name or password";
    private final String accountId;
    private final String revision;
    private String firstName;
    private String lastName;
    private String emailAddress;
    private String password;
    @JsonUnwrapped
    private Permissions permissions;
    private AccountStatus accountStatus;

    @JsonCreator
    public Account(@JacksonInject(value="accountId") String accountId, @JacksonInject(value="revision") String revision, @JsonProperty(value="emailAddress") String emailAddress, @JsonProperty(value="password") String password, @JsonProperty(value="firstName") String firstName, @JsonProperty(value="lastName") String lastName) {
        this.accountId = accountId;
        this.revision = revision;
        this.emailAddress = emailAddress;
        this.password = password;
        this.firstName = firstName;
        this.lastName = lastName;
    }

    @CouchId
    public String getAccountId() {
        return this.accountId;
    }

    @CouchRevision
    public String getRevision() {
        return this.revision;
    }

    @JsonIgnore
    public Set<String> getRoleTypes() {
        return this.permissions.getRoleTypes();
    }

    public String getPassword() {
        return this.password;
    }

    public Permissions getPermissions() {
        return this.permissions;
    }

    public AccountStatus getAccountStatus() {
        return this.accountStatus;
    }

    public String getUsername() {
        return this.emailAddress;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public CurrentUser toUser() {
        return new CurrentUser((CurrentUserSource)this);
    }

    public boolean equals(Object object) {
        if (object instanceof Account) {
            Account that = (Account)object;
            return this.accountId.equals(that.accountId);
        }
        return false;
    }

    public String toString() {
        return this.emailAddress;
    }
}

