/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.demo.common.app.domain;

import com.couchace.core.api.CouchServer;
import java.util.List;
import org.crazyyak.demo.common.app.DemoCouchServer;
import org.crazyyak.demo.common.app.domain.Account;
import org.crazyyak.dev.couchace.DefaultCouchStore;
import org.crazyyak.dev.security.domain.CurrentUser;
import org.crazyyak.dev.security.domain.CurrentUserSource;
import org.crazyyak.dev.security.domain.CurrentUserStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class AccountStore
extends DefaultCouchStore<Account>
implements CurrentUserStore {
    public static final String ACCOUNT_DESIGN_NAME = "account";

    @Autowired
    public AccountStore(DemoCouchServer couchServer, @Value(value="${couchdb.name}") String databaseName) {
        super((CouchServer)couchServer, databaseName, Account.class);
    }

    public String getDesignName() {
        return ACCOUNT_DESIGN_NAME;
    }

    public List<Account> getAll() {
        return super.getEntities("allAccounts", new String[0]);
    }

    public Account getByEmailAddress(String emailAddress) {
        if (emailAddress == null) {
            return null;
        }
        List response = super.getEntities("byEmailAddress", new String[]{emailAddress});
        return response.isEmpty() ? null : (Account)response.get(0);
    }

    public Account get(CurrentUser currentUser) {
        if (currentUser == null) {
            return null;
        }
        String documentId = currentUser.getAccountId();
        return (Account)super.getByDocumentId(documentId);
    }

    public CurrentUser getCurrentUser() {
        Object principal;
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null && (principal = auth.getPrincipal()) instanceof CurrentUser) {
            return (CurrentUser)principal;
        }
        return null;
    }

    public Account getCurrentAccount() {
        CurrentUser currentUser = this.getCurrentUser();
        return this.get(currentUser);
    }

    public CurrentUserSource getCurrentUserSourceByName(String username) {
        return this.getByEmailAddress(username);
    }

    public CurrentUserSource getCurrentUserSourceByEmail(String email) {
        return this.getByEmailAddress(email);
    }
}

