// Copyright (c) 2010-2013, Munchie Monster, LLC.
package org.crazyyak.demo.common.app.domain;

import com.couchace.annotations.*;
import com.fasterxml.jackson.annotation.*;
import java.util.*;
import org.crazyyak.dev.domain.account.*;
import org.crazyyak.dev.security.CurrentUser;

@CouchEntity(AccountStore.ACCOUNT_DESIGN_NAME)
public class Account implements CurrentUserSource {

  public static final String INVALID_USER_NAME_OR_PASSWORD = "Invalid user name or password";

  private final String accountId;
  private final String revision;

  private String firstName;
  private String lastName;

  private String emailAddress;
  private String password;

  private Permissions permissions;

  private AccountStatus accountStatus;

  @JsonCreator
  public Account(@JacksonInject("accountId") String accountId,
                 @JacksonInject("revision") String revision,
                 @JsonProperty("emailAddress") String emailAddress,
                 @JsonProperty("password") String password,
                 @JsonProperty("firstName") String firstName,
                 @JsonProperty("lastName") String lastName,
                 @JsonProperty("accountStatus") AccountStatus accountStatus,
                 @JsonProperty("roleTypes") Collection<String> roleTypes) {

    this.accountId = accountId;
    this.revision = revision;

    this.emailAddress = emailAddress;
    this.password = password;

    this.firstName = firstName;
    this.lastName = lastName;

    this.accountStatus = accountStatus;
    this.permissions = new Permissions(roleTypes);
  }

  @CouchId
  public String getAccountId() {
    return accountId;
  }

  @CouchRevision
  public String getRevision() {
    return revision;
  }

  public Set<String> getRoleTypes() {
    return permissions.getRoleTypes();
  }

  public String getPassword() {
    return password;
  }

  @JsonIgnore
  public Permissions getPermissions() {
    return permissions;
  }

  public AccountStatus getAccountStatus() {
    return accountStatus;
  }

  @JsonIgnore
  public String getUsername() {
    return emailAddress;
  }

  public String getEmailAddress() {
    return emailAddress;
  }

  public String getFirstName() {
    return firstName;
  }

  public String getLastName() {
    return lastName;
  }

  public CurrentUser toUser() {
    return new CurrentUser(this);
  }

  public boolean equals(Object object) {
    if (object instanceof Account) {
      Account that = (Account)object;
      return this.accountId.equals(that.accountId);
    }
    return false;
  }

  public String toString() {
    return emailAddress;
  }
}
