/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.demo.common.app;

import com.couchace.core.api.CouchDatabase;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import org.crazyyak.dev.common.id.IdGenerator;
import org.crazyyak.dev.common.id.TimeUuidIdGenerator;
import org.crazyyak.dev.couchace.DefaultCouchServer;
import org.crazyyak.dev.couchace.support.CouchUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DemoCouchServer
extends DefaultCouchServer {
    private final String databaseName;
    private final List<String> designNames = Arrays.asList("account");
    private final String prefix = "/yak-demo-common-app/json/";
    private final String suffix = "-design.json";

    @Autowired
    public DemoCouchServer(@Value(value="${couchdb.name}") String databaseName) {
        this.databaseName = databaseName;
    }

    public CouchDatabase database() {
        return super.database(this.databaseName);
    }

    @PostConstruct
    public void validateDatabases() throws IOException {
        CouchDatabase database = this.database();
        CouchUtils.createDatabase((CouchDatabase)database, (IdGenerator)new TimeUuidIdGenerator(), (String[])new String[]{"/yak-demo-common-app/json/account-load-yak.json", "/yak-demo-common-app/json/account-load-jdp.json"});
        CouchUtils.validateDesign((CouchDatabase)database, this.designNames, (String)"/yak-demo-common-app/json/", (String)"-design.json");
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public List<String> getDesignNames() {
        return this.designNames;
    }

    public String getPrefix() {
        return "/yak-demo-common-app/json/";
    }

    public String getSuffix() {
        return "-design.json";
    }
}

