/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.demo.gateway;

import java.util.List;
import org.crazyyak.demo.common.app.domain.Account;
import org.crazyyak.dev.common.json.JsonTranslator;
import org.crazyyak.dev.jackson.YakJacksonTranslator;
import org.crazyyak.dev.jackson.test.FreeBird;
import org.crazyyak.dev.jerseyclient.SimpleRestClient;
import org.joda.time.LocalDate;

public class DemoAppGateway {
    private SimpleRestClient client;

    public DemoAppGateway(String apiUrl, String username, String password) {
        YakJacksonTranslator translator = new YakJacksonTranslator();
        this.client = new SimpleRestClient((JsonTranslator)translator, apiUrl, username, password);
    }

    public Account getAccount(String username) {
        return (Account)this.client.get(Account.class, "/account/" + username, new String[0]);
    }

    public int getMonthOfYear(LocalDate localDate) {
        return (Integer)this.client.get(Integer.class, "/date/" + localDate + "/month-of-year", new String[0]);
    }

    public List<LocalDate> getDatesInMonth(LocalDate localDate) {
        return this.client.getList(LocalDate.class, "/date/" + localDate + "/dates-in-month", new String[0]);
    }

    public FreeBird getFreeBird(String firstMessage) {
        if (firstMessage == null) {
            return (FreeBird)this.client.get(FreeBird.class, "/free-bird", new String[0]);
        }
        return (FreeBird)this.client.get(FreeBird.class, "/free-bird", new String[]{"firstMessage=" + firstMessage});
    }

    public FreeBird postFreeBird(FreeBird freeBird) {
        return (FreeBird)this.client.post(FreeBird.class, "/free-bird", (Object)freeBird);
    }

    public FreeBird nullBird() {
        return (FreeBird)this.client.post(FreeBird.class, "/null-bird");
    }
}

