package org.crazyyak.demo.gateway;

import java.util.List;
import org.crazyyak.demo.common.app.domain.Account;
import org.crazyyak.dev.jackson.YakJacksonTranslator;
import org.crazyyak.dev.jackson.test.FreeBird;
import org.crazyyak.dev.jerseyclient.SimpleRestClient;
import org.joda.time.LocalDate;

public class DemoAppGateway {

  private SimpleRestClient client;

  public DemoAppGateway(String apiUrl, String username, String password) {
    YakJacksonTranslator translator = new YakJacksonTranslator();
    this.client = new SimpleRestClient(translator, apiUrl, username, password);
  }

  public Account getAccount(String username) {
    return client.get(Account.class, "/account/"+username);
  }

  public int getMonthOfYear(LocalDate localDate) {
    return client.get(Integer.class, "/date/"+localDate+"/month-of-year");
  }

  public List<LocalDate> getDatesInMonth(LocalDate localDate) {
    return client.getList(LocalDate.class, "/date/" + localDate + "/dates-in-month");
  }

  public FreeBird getFreeBird(String firstMessage) {
    if (firstMessage == null) {
      return client.get(FreeBird.class, "/free-bird");
    } else {
      return client.get(FreeBird.class, "/free-bird", "firstMessage="+firstMessage);
    }
  }

  public FreeBird postFreeBird(FreeBird freeBird) {
    return client.post(FreeBird.class, "/free-bird", freeBird);
  }

  public FreeBird nullBird() {
    return client.post(FreeBird.class, "/null-bird");
  }
}
