package org.crazyyak.demo.jerseyspring.controllers;

import javax.annotation.Resource;
import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import org.apache.commons.logging.*;
import org.crazyyak.demo.common.app.domain.*;
import org.crazyyak.demo.common.app.models.HomePageModel;
import org.glassfish.jersey.server.mvc.Viewable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path("/")
@Resource
@Component
public class JerseyRootController {

  private static final Log log = LogFactory.getLog(JerseyRootController.class);

  private final AccountStore accountStore;

  @Autowired
  public JerseyRootController(AccountStore accountStore) {
    log.debug("Created " + getClass().getName());

    this.accountStore = accountStore;
  }

  @GET
  @Produces(MediaType.TEXT_HTML)
  public Viewable getDefaultPage() {
    return renderHomePage(null);
  }

  @GET
  @Path("/signed-out")
  @Produces(MediaType.TEXT_HTML)
  public Viewable getSignedOut() {
    return renderHomePage("You have signed out.");
  }

  @GET
  @Path("/auth-failed")
  @Produces(MediaType.TEXT_HTML)
  public Viewable authenticationFailed() {
    return renderHomePage("You do not have permissions to access this resource.");
  }

  @GET
  @Path("/access-denied")
  @Produces(MediaType.TEXT_HTML)
  public Viewable accessDenied() {
    return renderHomePage("You do not have permissions to access this resource.");
  }

  private Viewable renderHomePage(String message) {
    Account account = accountStore.getCurrentAccount();
    return new Viewable("/index.tl", new HomePageModel(account, message));
  }
}
