package org.crazyyak.demo.jerseyspring.internal;

import org.crazyyak.demo.common.app.DemoSpringConfig;
import org.crazyyak.dev.jerseyspring.YakJerseyWebAppInitializer;
import org.crazyyak.dev.servlet.Log4jServletContextListener;
import org.glassfish.jersey.server.ResourceConfig;
import org.springframework.core.annotation.Order;
import org.springframework.web.context.WebApplicationContext;

import javax.servlet.ServletContext;

// Order required to ensure this initializer is run
// before Jersey 2.x Spring WebApplicationInitializer
@Order(0)
public class JerseyDemoWebAppInitializer extends YakJerseyWebAppInitializer {

  public JerseyDemoWebAppInitializer() {
  }

  @Override
  public Class<? extends ResourceConfig> getApplicationClass(ServletContext servletContext, WebApplicationContext appContext) {
    return JerseyDemoApplication.class;
  }

  @Override
  public String getEnvironmentPropertyName(ServletContext servletContext, WebApplicationContext appContext) {
    return "yak.demo.env";
  }

  @Override
  public String getProfilesPropertyName(ServletContext servletContext, WebApplicationContext appContext) {
    return "yak.demo.profiles";
  }

  @Override
  protected String getSpringConfigLocation(ServletContext servletContext, WebApplicationContext appContext) {
    return "classpath:/demo-jersey-app/yak-demo-jersey-app.xml";
  }

  @Override
  protected void addListeners(ServletContext servletContext, WebApplicationContext appContext) {

    servletContext.addListener(new Log4jServletContextListener());

    super.addListeners(servletContext, appContext);
  }

  @Override
  protected Class<?>[] getSpringConfigClasses(ServletContext servletContext, WebApplicationContext appContext) {
    return new Class[]{
        DemoSpringConfig.class,
        YakDemoJerseySpringConfig.class
    };
  }
}