package org.crazyyak.demo.jerseyspring.internal;

import java.net.*;
import org.apache.commons.logging.*;
import org.crazyyak.dev.couchace.spring.CouchPropertyPlaceholderConfigurer;
import org.crazyyak.dev.jackson.YakJacksonObjectMapper;
import org.springframework.context.annotation.*;

@Configuration
@ImportResource("classpath:/org/crazyyak/demo/jerseyspring/yak-demo-jersey-app.xml")
@ComponentScan(value={"org.crazyyak.demo.jerseyspring"})
public class YakDemoJerseySpringConfig {

  public static final Log log = LogFactory.getLog(YakDemoJerseySpringConfig.class);

  public YakDemoJerseySpringConfig() {
    log.debug("Created " + getClass().getName());
  }

  @Bean
  public YakJacksonObjectMapper yakJacksonObjectMapper() {
    return new YakJacksonObjectMapper();
  }

  @Bean
  public CouchPropertyPlaceholderConfigurer couchPropertyPlaceholderConfigurer() throws MalformedURLException, URISyntaxException {
    return new CouchPropertyPlaceholderConfigurer("yak-demo-jersey");
  }
}
