/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.demo.jerseyspring.controllers;

import javax.annotation.Resource;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.crazyyak.demo.common.app.domain.Account;
import org.crazyyak.demo.common.app.domain.AccountStore;
import org.crazyyak.demo.common.app.models.HomePageModel;
import org.glassfish.jersey.server.mvc.Viewable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/")
@Resource
@Component
public class JerseyRootController {
    private static final Log log = LogFactory.getLog(JerseyRootController.class);
    private final AccountStore accountStore;

    @Autowired
    public JerseyRootController(AccountStore accountStore) {
        log.debug((Object)("Created " + this.getClass().getName()));
        this.accountStore = accountStore;
    }

    @GET
    @Produces(value={"text/html"})
    public Viewable getDefaultPage() {
        return this.renderHomePage(null);
    }

    @GET
    @Path(value="/signed-out")
    @Produces(value={"text/html"})
    public Viewable getSignedOut() {
        return this.renderHomePage("You have signed out.");
    }

    @GET
    @Path(value="/auth-failed")
    @Produces(value={"text/html"})
    public Viewable authenticationFailed() {
        return this.renderHomePage("You do not have permissions to access this resource.");
    }

    @GET
    @Path(value="/access-denied")
    @Produces(value={"text/html"})
    public Viewable accessDenied() {
        return this.renderHomePage("You do not have permissions to access this resource.");
    }

    private Viewable renderHomePage(String message) {
        Account account = this.accountStore.getCurrentAccount();
        return new Viewable("/index.tl", (Object)new HomePageModel(account, message));
    }
}

