// Copyright (c) 2010-2013, Munchie Monster, LLC.
package org.crazyyak.demo.jerseyspring.controllers;

import org.crazyyak.demo.common.app.domain.Account;
import org.crazyyak.demo.common.app.domain.AccountStore;
import org.crazyyak.demo.common.app.models.AdminPageModel;
import org.glassfish.jersey.server.mvc.Viewable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

@Resource
@Component
@Path("/admin")
public class JerseyAdminController {

  private final AccountStore accountStore;

  @Autowired
  public JerseyAdminController(AccountStore accountStore) {
    this.accountStore = accountStore;
  }

  @GET
  @Produces(MediaType.TEXT_HTML)
  public Viewable getDefault() {
    Account account = accountStore.getCurrentAccount();
    AdminPageModel model = new AdminPageModel(account);
    return new Viewable("/admin/admin.tlml", model);
  }
}
