package org.crazyyak.demo.jerseyspring.internal;

import org.apache.commons.logging.*;
import org.crazyyak.dev.jerseyspring.*;
import org.crazyyak.dev.jerseyspring.jackson.JodaParamConverterProvider;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ResourceConfig;

public class JerseyDemoApplication extends ResourceConfig {

  private static final Log log = LogFactory.getLog(JerseyDemoApplication.class);

  public JerseyDemoApplication() {

    log.info("Demo application loaded.");

    property(YakJspMvcFeature.SUPPORTED_EXTENSIONS, "jsp, jspf");

    register(MultiPartFeature.class);
    register(YakJspMvcFeature.class);
    register(YakExceptionMapper.class);
    register(JodaParamConverterProvider.class);
    register(JerseyDemoReaderWriterProvider.class);
    register(ThymeleafTemplateProcessor.class);

    packages("org.crazyyak.demo.jerseyspring");
  }
}
