package org.crazyyak.demo.jerseyspring.internal;

import org.crazyyak.demo.common.app.domain.Account;
import org.crazyyak.dev.jackson.YakJacksonObjectMapper;
import org.crazyyak.dev.jackson.test.FreeBird;
import org.crazyyak.dev.jerseyspring.jackson.JacksonReaderWriterProvider;
import org.springframework.beans.factory.annotation.Autowired;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;

@Provider
public class JerseyDemoReaderWriterProvider extends JacksonReaderWriterProvider {

  @Autowired
  public JerseyDemoReaderWriterProvider(YakJacksonObjectMapper objectMapper) {
    super(objectMapper, MediaType.APPLICATION_JSON_TYPE);

    supportedTypes.add(Account.class);
    supportedTypes.add(FreeBird.class);
  }
}
