package org.crazyyak.demo.jerseyspring.internal;

import javax.servlet.*;
import org.apache.log4j.*;
import org.crazyyak.demo.common.app.DemoCommonSpringConfig;
import org.crazyyak.dev.jerseyspring.YakJerseyWebAppInitializer;
import org.crazyyak.dev.servlet.Log4jServletContextListener;
import org.glassfish.jersey.server.ResourceConfig;
import org.springframework.core.annotation.Order;
import org.springframework.web.context.WebApplicationContext;

// Order required to ensure this initializer is run
// before Jersey 2.x Spring WebApplicationInitializer
@Order(0)
public class JerseyDemoWebAppInitializer extends YakJerseyWebAppInitializer {

  public JerseyDemoWebAppInitializer() {
  }

  @Override
  public void onStartup(ServletContext servletContext) throws ServletException {
    String stndPattern = "%-5p: %d{MM-dd-yy HH:mm:ss} [%t] %c %x- %m%n";
    ConsoleAppender appender = new ConsoleAppender(new PatternLayout(stndPattern));
    appender.setThreshold(Level.WARN);
    Logger.getRootLogger().addAppender(appender);

    super.onStartup(servletContext);
  }

  @Override
  public Class<? extends ResourceConfig> getApplicationClass(ServletContext servletContext, WebApplicationContext appContext) {
    return JerseyDemoApplication.class;
  }

  @Override
  public String getEnvironmentPropertyName(ServletContext servletContext, WebApplicationContext appContext) {
    return "yak.demo.env";
  }

  @Override
  public String getProfilesPropertyName(ServletContext servletContext, WebApplicationContext appContext) {
    return "yak.demo.profiles";
  }

  @Override
  protected void addListeners(ServletContext servletContext, WebApplicationContext appContext) {

    servletContext.addListener(new Log4jServletContextListener());

    super.addListeners(servletContext, appContext);
  }

  @Override
  protected Class<?>[] getSpringConfigClasses(ServletContext servletContext, WebApplicationContext appContext) {
    return new Class[]{
        DemoCommonSpringConfig.class,
        YakDemoJerseySpringConfig.class
    };
  }
}