/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.demo.jerseyspring.controllers;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.crazyyak.demo.common.app.domain.Account;
import org.crazyyak.demo.common.app.domain.AccountStore;
import org.crazyyak.dev.common.StringUtils;
import org.crazyyak.dev.common.fine.FineMessage;
import org.crazyyak.dev.common.fine.FineMessageSetBuilder;
import org.crazyyak.dev.common.fine.FineMessageSetImpl;
import org.crazyyak.dev.common.fine.TraitMap;
import org.crazyyak.dev.domain.locality.LatLng;
import org.crazyyak.dev.jackson.test.FreeBird;
import org.joda.money.Money;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Resource
@Component
@Path(value="/api")
public class JerseyApiController {
    private final AccountStore accountStore;

    @Autowired
    public JerseyApiController(AccountStore accountStore) {
        this.accountStore = accountStore;
    }

    @GET
    @Path(value="/account/{emailAddress}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Account getDefault(@PathParam(value="emailAddress") String emailAddress) {
        return this.accountStore.getByEmailAddress(emailAddress);
    }

    @GET
    @Path(value="/date/{date}/month-of-year")
    @Produces(value={"application/json"})
    public int getCurrentDate(@PathParam(value="date") LocalDate localDate) {
        return localDate.getMonthOfYear();
    }

    @GET
    @Path(value="/date/{date}/dates-in-month")
    @Produces(value={"application/json"})
    public List<LocalDate> getDaysInMonth(@PathParam(value="date") LocalDate localDate) {
        LocalDate firstDate = localDate.dayOfMonth().withMinimumValue();
        int max = localDate.dayOfMonth().withMaximumValue().getDayOfMonth();
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>();
        for (int i = 0; i < max; ++i) {
            dates.add(firstDate.plusDays(i));
        }
        return dates;
    }

    @GET
    @Path(value="/plain-text")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String getPlainText(@QueryParam(value="signature") String signature) {
        if (StringUtils.isBlank((Object)signature)) {
            signature = "- One Crazy Yak";
        }
        return "This is plain text.\nThere really isn't much to it.\n\n\t" + signature;
    }

    @GET
    @Path(value="/free-bird")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public FreeBird getFreeBird(@QueryParam(value="firstMessage") String firstMessage) {
        if (StringUtils.isBlank((Object)firstMessage)) {
            firstMessage = "Hi, my name is Joe!";
        }
        return this.createFreeBird(firstMessage);
    }

    @POST
    @Path(value="/null-bird")
    @Produces(value={"application/json"})
    public FreeBird getNullBird() {
        return this.createFreeBird("This is a null bird.");
    }

    @POST
    @Path(value="/free-bird")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public FreeBird echoFreeBird(FreeBird freeBird) {
        return freeBird;
    }

    private FreeBird createFreeBird(String firstMessage) {
        return new FreeBird("string-value", Long.MAX_VALUE, Integer.MIN_VALUE, new LatLng("37.3382030", "-119.7085060"), new org.crazyyak.dev.domain.money.Money("19.95"), Money.parse((String)"USD 99.99"), new LocalTime((Object)"12:32:13"), new LocalDate((Object)"1975-05-06"), new LocalDateTime((Object)"1975-05-06T12:32:13"), new TraitMap(new String[]{"first:yes", "empty-value:", "null-value", "last:ok"}), FineMessage.withText((String)"This message is fine!"), (FineMessageSetImpl)new FineMessageSetBuilder().withText(firstMessage).withAll("I'm Suzie", "999", new TraitMap(new String[]{"girl:true", "boy:false"})).build());
    }
}

