package org.crazyyak.demo.webmvc.controllers;

import org.apache.commons.logging.*;
import org.crazyyak.demo.common.app.domain.*;
import org.crazyyak.demo.common.app.models.HomePageModel;
import org.crazyyak.dev.webmvc.Viewable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.thymeleaf.TemplateEngine;

@Controller
public class MvcRootController {

  private static final Log log = LogFactory.getLog(MvcRootController.class);

  private final AccountStore accountStore;

  @Autowired
  private TemplateEngine templateEngine;

  @Autowired
  public MvcRootController(AccountStore accountStore) {
    log.debug("Created " + getClass().getName());

    this.accountStore = accountStore;
  }

  @RequestMapping("/")
  public Viewable getDefaultPage() {
    return renderHomePage(null);
  }

  @RequestMapping("/signed-out")
  public Viewable getSignedOut() {
    return renderHomePage("You have signed out.");
  }

  @RequestMapping("/auth-failed")
  public Viewable authenticationFailed() {
    return renderHomePage("You do not have permissions to access this resource.");
  }


  @RequestMapping("/access-denied")
  public Viewable accessDenied() {
    return renderHomePage("You do not have permissions to access this resource.");
  }

  private Viewable renderHomePage(String message) {
    Account account = accountStore.getCurrentAccount();
    return new Viewable("index.tl", new HomePageModel(account, message));
  }
}
