package org.crazyyak.demo.webmvc.internal;

import javax.servlet.*;
import org.apache.log4j.*;
import org.crazyyak.demo.common.app.DemoCommonSpringConfig;
import org.crazyyak.dev.webmvc.*;
import org.springframework.core.annotation.Order;
import org.springframework.web.context.WebApplicationContext;

// Order required to ensure this initializer is run
// before Jersey 2.x Spring WebApplicationInitializer
@Order(0)
public class MvcDemoWebAppInitializer extends YakSpringWebAppInitializer {

  public MvcDemoWebAppInitializer() {
  }

  @Override
  public void onStartup(ServletContext servletContext) throws ServletException {
    String stndPattern = "%-5p: %d{MM-dd-yy HH:mm:ss} [%t] %c %x- %m%n";
    ConsoleAppender appender = new ConsoleAppender(new PatternLayout(stndPattern));
    appender.setThreshold(Level.WARN);
    Logger.getRootLogger().addAppender(appender);

    super.onStartup(servletContext);
  }

  @Override
  public String getEnvironmentPropertyName(ServletContext servletContext, WebApplicationContext appContext) {
    return "yak.demo.env";
  }

  @Override
  public String getProfilesPropertyName(ServletContext servletContext, WebApplicationContext appContext) {
    return "yak.demo.profiles";
  }

  @Override
  protected Class<?>[] getSpringConfigClasses(ServletContext servletContext, WebApplicationContext appContext) {
    return new Class[]{
        MvcSpringConfig.class,
        DemoCommonSpringConfig.class,
        YakDemoWebMvcSpringConfig.class
    };
  }
}