/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.demo.webmvc.controllers;

import java.util.ArrayList;
import java.util.List;
import org.crazyyak.demo.common.app.domain.Account;
import org.crazyyak.demo.common.app.domain.AccountStore;
import org.crazyyak.dev.common.StringUtils;
import org.crazyyak.dev.common.fine.FineMessage;
import org.crazyyak.dev.common.fine.FineMessageSetBuilder;
import org.crazyyak.dev.common.fine.FineMessageSetImpl;
import org.crazyyak.dev.common.fine.TraitMap;
import org.crazyyak.dev.domain.locality.LatLng;
import org.crazyyak.dev.jackson.test.FreeBird;
import org.joda.money.Money;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class MvcApiController {
    private final AccountStore accountStore;

    @Autowired
    public MvcApiController(AccountStore accountStore) {
        this.accountStore = accountStore;
    }

    @RequestMapping(value={"/account/{emailAddress}"})
    public Account getAccount(@PathVariable String emailAddress) {
        return this.accountStore.getByEmailAddress(emailAddress);
    }

    @RequestMapping(value={"/date/{date}/month-of-year"})
    public int getCurrentDate(@PathVariable LocalDate date) {
        return date.getMonthOfYear();
    }

    @RequestMapping(value={"/date/{date}/dates-in-month"})
    public List<LocalDate> getDaysInMonth(@PathVariable LocalDate date) {
        LocalDate firstDate = date.dayOfMonth().withMinimumValue();
        int max = date.dayOfMonth().withMaximumValue().getDayOfMonth();
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>();
        for (int i = 0; i < max; ++i) {
            dates.add(firstDate.plusDays(i));
        }
        return dates;
    }

    @RequestMapping(value={"/plain-text"}, produces={"text/plain"})
    public String getPlainText(@RequestParam(required=false) String signature) {
        if (StringUtils.isBlank((Object)signature)) {
            signature = "- One Crazy Yak";
        }
        return "This is plain text.\nThere really isn't much to it.\n\n\t" + signature;
    }

    @RequestMapping(value={"/free-bird"})
    public FreeBird getFreeBird(@RequestParam(required=false) String firstMessage) {
        if (StringUtils.isBlank((Object)firstMessage)) {
            firstMessage = "Hi, my name is Joe!";
        }
        return this.createFreeBird(firstMessage);
    }

    @RequestMapping(value={"/free-bird"}, method={RequestMethod.POST})
    public FreeBird echoFreeBird(@RequestBody FreeBird freeBird) {
        return freeBird;
    }

    @RequestMapping(value={"/null-bird"}, method={RequestMethod.POST})
    public FreeBird getNullBird() {
        return this.createFreeBird("This is a null bird.");
    }

    private FreeBird createFreeBird(String firstMessage) {
        return new FreeBird("string-value", Long.MAX_VALUE, Integer.MIN_VALUE, new LatLng("37.3382030", "-119.7085060"), new org.crazyyak.dev.domain.money.Money("19.95"), Money.parse((String)"USD 99.99"), new LocalTime((Object)"12:32:13"), new LocalDate((Object)"1975-05-06"), new LocalDateTime((Object)"1975-05-06T12:32:13"), new TraitMap(new String[]{"first:yes", "empty-value:", "null-value", "last:ok"}), FineMessage.withText((String)"This message is fine!"), (FineMessageSetImpl)new FineMessageSetBuilder().withText(firstMessage).withAll("I'm Suzie", "999", new TraitMap(new String[]{"girl:true", "boy:false"})).build());
    }
}

