/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.demo.webmvc.controllers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.crazyyak.demo.common.app.domain.Account;
import org.crazyyak.demo.common.app.domain.AccountStore;
import org.crazyyak.demo.common.app.models.HomePageModel;
import org.crazyyak.dev.webmvc.Viewable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class MvcRootController {
    private static final Log log = LogFactory.getLog(MvcRootController.class);
    private final AccountStore accountStore;
    @Value(value="${google.auth.clientId}")
    private String clientId;

    @Autowired
    public MvcRootController(AccountStore accountStore) {
        log.debug((Object)("Created " + this.getClass().getName()));
        this.accountStore = accountStore;
    }

    @RequestMapping(value={"/"})
    public Viewable getDefaultPage() {
        return this.renderHomePage(null);
    }

    @RequestMapping(value={"/signed-out"})
    public Viewable getSignedOut() {
        return this.renderHomePage("You have signed out.");
    }

    @RequestMapping(value={"/auth-failed"})
    public Viewable authenticationFailed() {
        return this.renderHomePage("You do not have permissions to access this resource.");
    }

    @RequestMapping(value={"/access-denied"})
    public Viewable accessDenied() {
        return this.renderHomePage("You do not have permissions to access this resource.");
    }

    private Viewable renderHomePage(String message) {
        Account account = this.accountStore.getCurrentAccount();
        return new Viewable("index.tlml", (Object)new HomePageModel(account, message, this.clientId));
    }
}

