/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.amazon;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.crazyyak.dev.amazon.S3ResourceLoader;
import org.crazyyak.dev.common.ReflectUtils;
import org.crazyyak.dev.common.exceptions.ExceptionUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class S3PropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    private final List<String> s3Locations = new ArrayList<String>();
    private final List<Resource> resources = new ArrayList<Resource>();

    public S3PropertyPlaceholderConfigurer() {
    }

    public S3PropertyPlaceholderConfigurer(String systemPropertyName) throws MalformedURLException, URISyntaxException {
        ExceptionUtils.assertNotNull((Object)systemPropertyName, (String)"systemPropertyName");
        String systemPropertyValue = System.getProperty(systemPropertyName);
        ExceptionUtils.assertNotNull((Object)systemPropertyValue, (String)systemPropertyName);
        if (systemPropertyValue.toLowerCase().startsWith("s3:")) {
            this.s3Locations.add(systemPropertyValue);
        } else {
            URL url = new URL(systemPropertyValue);
            this.resources.add((Resource)new UrlResource(url));
        }
    }

    public void setLocations(Resource[] resources) {
        Collections.addAll(this.resources, resources);
    }

    public void setS3Locations(String[] s3Locations) {
        for (String s3Location : s3Locations) {
            String path = this.resolvePlaceholder(s3Location, new Properties());
            this.s3Locations.add(path);
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        ArrayList<Resource> allResources = new ArrayList<Resource>();
        allResources.addAll(this.resources);
        if (!this.s3Locations.isEmpty()) {
            S3ResourceLoader resourceLoader = new S3ResourceLoader();
            for (String s3Location : this.s3Locations) {
                allResources.add(resourceLoader.getResource(s3Location));
            }
        }
        super.setLocations((Resource[])ReflectUtils.toArray(Resource.class, allResources));
        super.postProcessBeanFactory(beanFactory);
    }

    protected void loadProperties(Properties props) throws IOException {
        super.loadProperties(props);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith("system.")) continue;
            key = key.substring(7);
            System.setProperty(key, (String)entry.getValue());
        }
    }
}

