/*
 * Copyright 2012 Jacob D Parr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.crazyyak.dev.amazon;

import com.amazonaws.auth.*;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient;
import com.amazonaws.services.simpleemail.model.*;
import org.crazyyak.dev.common.StringUtils;
import org.crazyyak.dev.net.email.*;

public class AwsUtils {

  private static final String AWS_ACCESS_KEY_ID = "AWS_ACCESS_KEY_ID";
  private static final String AWS_SECRET_KEY = "AWS_SECRET_KEY";

  public static AWSCredentials getCredentials() {
    return new BasicAWSCredentials(getAccessKey(), getSecretKey());
  }

  public static String getAccessKey() {
    return getProperty(AWS_ACCESS_KEY_ID);
  }

  public static String getSecretKey() {
    return getProperty(AWS_SECRET_KEY);
  }

  public static AmazonS3Client newAmazonS3Client() {
    return new AmazonS3Client(getCredentials());
  }

  private static String getProperty(String propertyName) {
    String value = System.getProperty(propertyName);
    if (StringUtils.isNotBlank(value)) {
      return value;
    }

    value = System.getenv(propertyName);
    if (StringUtils.isNotBlank(value)) {
      return value;
    }

    String msg = String.format("The property \"%s\" was not found in as a system property or environment variable.", propertyName);
    throw new IllegalArgumentException(msg);
  }

/*
  public static void sendSms(String message, String fromAddress, SmsAddress toAddress) {

    SendEmailRequest sendEmailRequest = new SendEmailRequest();
    sendEmailRequest.withSource(fromAddress);
    sendEmailRequest.withReturnPath(fromAddress);
    sendEmailRequest.withReplyToAddresses(fromAddress);
    sendEmailRequest.setDestination(new Destination().withToAddresses(toAddress.getValue()));

    Content subject = new Content().withCharset("UTF-8").withData("");

    Body body = new Body();
    body.withText(new Content().withCharset("UTF-8").withData(message));

    sendEmailRequest.setMessage(new Message(subject, body));

    new AmazonSimpleEmailServiceClient(getCredentials()).sendEmail(sendEmailRequest);
  }
*/

/*
  public static void sendEmail(String emailSubject, String htmlContent, String fromAddress, EmailAddress toAddress) {

    Body body = new Body();
    if (StringUtils.isBlank(htmlContent)) {
      body.withText(new Content().withCharset("UTF-8").withData("-no message-"));
    } else {
      body.withHtml(new Content().withCharset("UTF-8").withData(htmlContent));
    }

    SendEmailRequest sendEmailRequest = new SendEmailRequest();
    sendEmailRequest.withSource(fromAddress);
    sendEmailRequest.withReturnPath(fromAddress);
    sendEmailRequest.withReplyToAddresses(fromAddress);
    sendEmailRequest.setDestination(new Destination().withToAddresses(toAddress.getValue()));

    Content subject = new Content().withCharset("UTF-8").withData(emailSubject);
    sendEmailRequest.setMessage(new Message(subject, body));

    new AmazonSimpleEmailServiceClient(getCredentials()).sendEmail(sendEmailRequest);
  }
*/
}
