/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.amazon;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import java.io.InputStream;
import org.crazyyak.dev.amazon.AwsUtils;
import org.crazyyak.dev.amazon.S3ResourceException;
import org.crazyyak.dev.common.IoUtils;
import org.crazyyak.dev.common.exceptions.ExceptionUtils;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class S3ResourceLoader
implements ResourceLoader {
    private static final String LOCATION_PREFIX = "s3://";
    private AmazonS3 client = AwsUtils.newAmazonS3Client();

    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public Resource getResource(String location) {
        try {
            S3Path s3Path = this.parseS3Path(location);
            S3Object s3Object = this.client.getObject(s3Path.bucket, s3Path.key);
            S3ObjectInputStream inputStream = s3Object.getObjectContent();
            byte[] bytes = IoUtils.toBytes((InputStream)inputStream);
            return new ByteArrayResource(bytes, location);
        }
        catch (Exception e) {
            throw new S3ResourceException("could not load resource from " + location, e);
        }
    }

    private S3Path parseS3Path(String location) {
        ExceptionUtils.assertNotZeroLength((String)location, (String)"location");
        if (!location.startsWith(LOCATION_PREFIX)) {
            String msg = String.format("AWS S3 resource locations must start with \"%s\": %s.", LOCATION_PREFIX, location);
            throw new IllegalArgumentException(msg);
        }
        S3Path s3Path = new S3Path();
        String path = location.substring(LOCATION_PREFIX.length());
        int pos = path.indexOf("/");
        if (pos < 0) {
            String msg = String.format("The path does not specify a bucket name: %s.", path);
            throw new IllegalArgumentException(msg);
        }
        s3Path.bucket = path.substring(0, pos);
        s3Path.key = path.substring(pos + 1, path.length());
        return s3Path;
    }

    public static class S3Path {
        public String bucket;
        public String key;
    }
}

