/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.amazon;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import org.crazyyak.dev.common.StringUtils;

public class AwsUtils {
    private static final String AWS_ACCESS_KEY_ID = "AWS_ACCESS_KEY_ID";
    private static final String AWS_SECRET_KEY = "AWS_SECRET_KEY";

    public static AWSCredentials getCredentials() {
        return new BasicAWSCredentials(AwsUtils.getAccessKey(), AwsUtils.getSecretKey());
    }

    public static String getAccessKey() {
        return AwsUtils.getProperty(AWS_ACCESS_KEY_ID);
    }

    public static String getSecretKey() {
        return AwsUtils.getProperty(AWS_SECRET_KEY);
    }

    public static AmazonS3Client newAmazonS3Client() {
        return new AmazonS3Client(AwsUtils.getCredentials());
    }

    private static String getProperty(String propertyName) {
        String value = System.getProperty(propertyName);
        if (StringUtils.isNotBlank((Object)value)) {
            return value;
        }
        value = System.getenv(propertyName);
        if (StringUtils.isNotBlank((Object)value)) {
            return value;
        }
        String msg = String.format("The property \"%s\" was not found in as a system property or environment variable.", propertyName);
        throw new IllegalArgumentException(msg);
    }
}

