/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.common.exceptions;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.crazyyak.dev.common.ReflectUtils;
import org.crazyyak.dev.common.StringUtils;
import org.crazyyak.dev.common.exceptions.NotADirectoryException;
import org.crazyyak.dev.common.exceptions.NotAFileException;

public class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static void assertIsFile(File file) throws NotAFileException, FileNotFoundException {
        ExceptionUtils.assertPathExists(file);
        if (!file.isFile()) {
            throw new NotAFileException(file);
        }
    }

    public static void assertIsDirectory(File file) throws NotADirectoryException, FileNotFoundException {
        ExceptionUtils.assertPathExists(file);
        if (!file.isDirectory()) {
            throw new NotADirectoryException(file);
        }
    }

    public static void assertPathExists(File file) throws FileNotFoundException {
        if (!file.exists()) {
            String msg = String.format("The path \"%s\" does not exist.", file.getAbsolutePath());
            throw new FileNotFoundException(msg);
        }
    }

    public static void assertNotZeroLength(String value, String name) {
        if (value == null) {
            String msg = String.format("The value \"%s\" cannot be null.", name);
            throw new NullPointerException(msg);
        }
        if (value.isEmpty()) {
            String msg = String.format("The value \"%s\" is an empty string.", name);
            throw new NullPointerException(msg);
        }
    }

    public static <T> T assertNotNull(T value, String name) {
        if (value == null) {
            String msg = String.format("The value \"%s\" cannot be null.", name);
            throw ExceptionUtils.trimStackTrace(new NullPointerException(msg));
        }
        return value;
    }

    public static void assertPositive(long value, String name) {
        if (value <= 0L) {
            String msg = String.format("The value \"%s\" cannot be less than zero.", name);
            throw ExceptionUtils.trimStackTrace(new IllegalArgumentException(msg));
        }
    }

    public static void assertNegative(long value, String name) {
        if (value >= 0L) {
            String msg = String.format("The value \"%s\" cannot be greater than zero.", name);
            throw ExceptionUtils.trimStackTrace(new IllegalArgumentException(msg));
        }
    }

    private static <T extends Throwable> T trimStackTrace(T ex) {
        ArrayList elements = new ArrayList();
        Collections.addAll(elements, ex.getStackTrace());
        elements.remove(0);
        ex.setStackTrace(ReflectUtils.toArray(StackTraceElement.class, elements));
        return ex;
    }

    public static Throwable getRootCause(Throwable e) {
        Throwable cause = e.getCause();
        while (cause != null && cause != e) {
            e = cause;
            cause = e.getCause();
        }
        return e;
    }

    public static String getMessage(Throwable e) {
        String msg = e.getMessage();
        return StringUtils.isBlank(msg) ? e.getClass().getName() : msg;
    }

    public static String getRootMessage(Throwable e) {
        String msg = (e = ExceptionUtils.getRootCause(e)).getMessage();
        return StringUtils.isBlank(msg) ? e.getClass().getName() : msg;
    }

    public static String getStackTrace(Throwable e) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        e.printStackTrace(pw);
        return writer.toString();
    }

    public static List<? extends Throwable> getRootCauses(Throwable e) {
        Throwable last = e.getCause();
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        list.add(e);
        while (last != e && last != null) {
            list.add(last);
            e = last;
            last = e.getCause();
        }
        return list;
    }
}

