/*
 * Copyright 2012 Jacob D Parr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.crazyyak.dev.common.exceptions;

public class ApiException extends RuntimeException {

  private int httpStatus;

  public ApiException(String message) {
    this(400, message);
  }

  public ApiException(int httpStatus, String message) {
    super(message);
    this.httpStatus = httpStatus;
  }

  public ApiException(int httpStatus, String message, Throwable cause) {
    super(message, cause);
    this.httpStatus = httpStatus;
  }

  public int getHttpStatus() {
    return httpStatus;
  }

  public static ApiException badRequest(String message) {
    return new ApiException(400, message);
  }

  public static ApiException forbidden() {
    return new ApiException(403, null);
  }
  public static ApiException forbidden(String message) {
    return new ApiException(403, message);
  }

  public static ApiException notFound() {
    return new ApiException(404, null);
  }
  public static ApiException notFound(String message) {
    return new ApiException(404, message);
  }

  public static ApiException conflict() {
    return new ApiException(409, null);
  }
  public static ApiException conflict(String message) {
    return new ApiException(409, message);
  }

  public static ApiException preconditionFailed(String message) {
    return new ApiException(412, message);
  }

  public static ApiException internalServerError(String message) {
    return new ApiException(500, message);
  }
  public static ApiException internalServerError(String message, Throwable cause) {
    return new ApiException(500, message, cause);
  }
}
