/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.common.exceptions;

public class ApiException
extends RuntimeException {
    private int httpStatus;

    public ApiException(String message) {
        this(400, message);
    }

    public ApiException(int httpStatus, String message) {
        super(message);
        this.httpStatus = httpStatus;
    }

    public ApiException(int httpStatus, String message, Throwable cause) {
        super(message, cause);
        this.httpStatus = httpStatus;
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public static ApiException badRequest(String message) {
        return new ApiException(400, message);
    }

    public static ApiException forbidden() {
        return new ApiException(403, null);
    }

    public static ApiException forbidden(String message) {
        return new ApiException(403, message);
    }

    public static ApiException notFound() {
        return new ApiException(404, null);
    }

    public static ApiException notFound(String message) {
        return new ApiException(404, message);
    }

    public static ApiException conflict() {
        return new ApiException(409, null);
    }

    public static ApiException conflict(String message) {
        return new ApiException(409, message);
    }

    public static ApiException preconditionFailed(String message) {
        return new ApiException(412, message);
    }

    public static ApiException internalServerError(String message) {
        return new ApiException(500, message);
    }

    public static ApiException internalServerError(String message, Throwable cause) {
        return new ApiException(500, message, cause);
    }
}

