/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.common;

import org.crazyyak.dev.common.StringUtils;

public class EnvUtils {
    private EnvUtils() {
    }

    public static String findProperty(String propertyName) {
        return EnvUtils.findProperty(propertyName, null);
    }

    public static String findProperty(String propertyName, String defaultValue) {
        String actualValue = EnvUtils.getSystemProperty(propertyName);
        if (StringUtils.isBlank(actualValue)) {
            actualValue = EnvUtils.getEnvironmentProperty(propertyName);
        }
        return StringUtils.isBlank(actualValue) ? defaultValue : actualValue;
    }

    public static String getEnvironmentProperty(String propertyName) {
        return System.getenv(propertyName);
    }

    public static String getEnvironmentProperty(String propertyName, String defaultValue) {
        String actualValue = System.getenv(propertyName);
        return StringUtils.isBlank(actualValue) ? defaultValue : actualValue;
    }

    public static String getSystemProperty(String propertyName) {
        return System.getProperty(propertyName);
    }

    public static String getSystemProperty(String propertyName, String defaultValue) {
        String actualValue = System.getProperty(propertyName);
        return StringUtils.isBlank(actualValue) ? defaultValue : actualValue;
    }
}

