package org.crazyyak.dev.common.sequence;

import org.crazyyak.dev.common.sequence.uuid.TimeUUID;

public class TimeUUIDIdGenerator implements IdGenerator {

    private String lastId;

    public TimeUUIDIdGenerator() {
    }

    @Override
    public synchronized String newId() {
        String newId = new TimeUUID().toString();
        lastId = newId;
        return newId;
    }

    @Override
    public synchronized String getLastId() {
        return lastId;
    }

}