/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.common.sequence.uuid;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.crazyyak.dev.common.sequence.uuid.TimeUUIDGenerator;
import org.crazyyak.dev.common.sequence.uuid.TimeUUIDHexUtil;
import org.omg.CORBA.portable.IDLEntity;

public class TimeUUID
implements Comparable<TimeUUID>,
Externalizable,
Cloneable,
IDLEntity {
    static final long serialVersionUID = 7435962790062944603L;
    public long time;
    public long clockSeqAndNode;

    public TimeUUID() {
        this(TimeUUIDGenerator.newTime(), TimeUUIDGenerator.getClockSeqAndNode());
    }

    public TimeUUID(long time, long clockSeqAndNode) {
        this.time = time;
        this.clockSeqAndNode = clockSeqAndNode;
    }

    public TimeUUID(TimeUUID u) {
        this(u.time, u.clockSeqAndNode);
    }

    public TimeUUID(CharSequence s) {
        this(TimeUUIDHexUtil.parseLong(s.subSequence(0, 18)), TimeUUIDHexUtil.parseLong(s.subSequence(19, 36)));
    }

    @Override
    public int compareTo(TimeUUID t) {
        if (this == t) {
            return 0;
        }
        if (this.time > t.time) {
            return 1;
        }
        if (this.time < t.time) {
            return -1;
        }
        if (this.clockSeqAndNode > t.clockSeqAndNode) {
            return 1;
        }
        if (this.clockSeqAndNode < t.clockSeqAndNode) {
            return -1;
        }
        return 0;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.time);
        out.writeLong(this.clockSeqAndNode);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.time = in.readLong();
        this.clockSeqAndNode = in.readLong();
    }

    public final String toString() {
        return this.toAppendable(null).toString();
    }

    public StringBuffer toStringBuffer(StringBuffer in) {
        StringBuffer out = in;
        if (out == null) {
            out = new StringBuffer(36);
        } else {
            out.ensureCapacity(out.length() + 36);
        }
        return (StringBuffer)this.toAppendable(out);
    }

    public Appendable toAppendable(Appendable a) {
        Appendable out = a;
        if (out == null) {
            out = new StringBuilder(36);
        }
        try {
            TimeUUIDHexUtil.append(out, (int)(this.time >> 32)).append('-');
            TimeUUIDHexUtil.append(out, (short)(this.time >> 16)).append('-');
            TimeUUIDHexUtil.append(out, (short)this.time).append('-');
            TimeUUIDHexUtil.append(out, (short)(this.clockSeqAndNode >> 48)).append('-');
            TimeUUIDHexUtil.append(out, this.clockSeqAndNode, 12);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out;
    }

    public int hashCode() {
        return (int)(this.time >> 32 ^ this.time ^ this.clockSeqAndNode >> 32 ^ this.clockSeqAndNode);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public final long getTime() {
        return this.time;
    }

    public final long getClockSeqAndNode() {
        return this.clockSeqAndNode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TimeUUID)) {
            return false;
        }
        return this.compareTo((TimeUUID)obj) == 0;
    }

    public static TimeUUID nilUUID() {
        return new TimeUUID(0L, 0L);
    }
}

