/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.common.fine;

import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.crazyyak.dev.common.BeanUtils;

public class TraitMap {
    private static final TraitMap empty = new TraitMap(new String[0]);
    private final SortedMap<String, String> traitMap;

    public static TraitMap empty() {
        return empty;
    }

    public TraitMap(Map<?, ?> givenMap) {
        TreeMap<String, String> localMap = new TreeMap<String, String>();
        for (Map.Entry<?, ?> entry : givenMap.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null) continue;
            if (value == null) {
                localMap.put(key.toString().toUpperCase(), null);
                continue;
            }
            localMap.put(key.toString().toUpperCase(), value.toString());
        }
        this.traitMap = Collections.unmodifiableSortedMap(localMap);
    }

    public TraitMap(String ... traitStrings) {
        this(BeanUtils.toMap(traitStrings));
    }

    public Map<String, String> toMap() {
        return this.traitMap;
    }

    public boolean isEmpty() {
        return this.traitMap.isEmpty();
    }

    public int getSize() {
        return this.traitMap.size();
    }

    public boolean isNotEmpty() {
        return !this.traitMap.isEmpty();
    }

    public boolean hasTrait(String key) {
        return key != null && this.traitMap.containsKey(key.toUpperCase());
    }

    public boolean hasValue(String key, String checkValue) {
        String value = (String)this.traitMap.get(key.toUpperCase());
        if (checkValue == null) {
            return value == null;
        }
        return checkValue.equals(value);
    }

    public String getValue(String key) {
        return (String)this.traitMap.get(key.toUpperCase());
    }

    public String getText() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.traitMap.entrySet()) {
            sb.append(entry.getKey());
            sb.append(":");
            if (entry.getValue() == null) {
                sb.append("null");
            } else {
                sb.append("\"");
                sb.append(entry.getValue());
                sb.append("\"");
            }
            sb.append(", ");
        }
        if (sb.length() > 2) {
            sb.delete(sb.length() - 2, sb.length());
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TraitMap that = (TraitMap)o;
        return this.traitMap.equals(that.traitMap);
    }

    public int hashCode() {
        return this.traitMap.hashCode();
    }

    public String toString() {
        return this.getText();
    }
}

