/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.common;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.crazyyak.dev.common.ReflectUtils;

public class BeanUtils {
    public static List<String> getValuesFromCollection(Collection objects, String propertyName) {
        try {
            Object[] args = new Object[]{};
            ArrayList<String> retVal = new ArrayList<String>();
            for (Object object : objects) {
                if (object == null) {
                    retVal.add(null);
                    continue;
                }
                Method method = ReflectUtils.getReadMethod(object.getClass(), propertyName);
                if (method == null) {
                    throw new IllegalArgumentException("The accessor method for the property \"" + propertyName + "\" does not exist.");
                }
                Object value = method.invoke(object, args);
                if (value instanceof String || value instanceof Number) {
                    retVal.add(value.toString());
                    continue;
                }
                if (value instanceof Boolean) {
                    retVal.add((Boolean)value != false ? "1" : "0");
                    continue;
                }
                retVal.add(null);
            }
            return retVal;
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception building list", ex);
        }
    }

    public static StringBuffer getObjectAsString(Object object, boolean newline) {
        Class<?> type;
        StringBuffer space = new StringBuffer("     ");
        StringBuffer buffer = new StringBuffer();
        buffer.append(type.getName());
        buffer.append(":");
        buffer.append(space);
        HashMap<String, String> map = new HashMap<String, String>();
        for (type = object.getClass(); type != null; type = type.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = type.getDeclaredFields()) {
                try {
                    if (Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers()) || map.get(field.getName()) != null) continue;
                    map.put(field.getName(), field.getName());
                    field.setAccessible(true);
                    Object value = field.get(object);
                    buffer.append("(");
                    if (value == null) {
                        buffer.append(field.getName());
                        buffer.append("=null");
                    } else if (field.getType().isArray()) {
                        buffer.append("[");
                        for (int arrayDex = 0; arrayDex < Array.getLength(value); ++arrayDex) {
                            buffer.append(BeanUtils.getObjectAsString(Array.get(value, arrayDex), false));
                            if (arrayDex >= Array.getLength(value) - 1) continue;
                            buffer.append(",");
                            buffer.append(space);
                        }
                        buffer.append("]");
                    } else {
                        buffer.append(field.getName());
                        buffer.append("=");
                        buffer.append(value.toString());
                    }
                    buffer.append(")");
                    if (newline) {
                        buffer.append("\n");
                    } else if (field != fields[fields.length - 1]) {
                        buffer.append(",");
                    }
                    buffer.append(space);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    System.exit(0);
                }
            }
        }
        return buffer;
    }

    public static boolean objectsNotEqual(Object valueA, Object valueB) {
        return !BeanUtils.objectsEqual(valueA, valueB);
    }

    public static <T> boolean objectsEqual(T valueA, T valueB) {
        if (valueA == valueB) {
            return true;
        }
        if (valueA == null || valueB == null) {
            return false;
        }
        return valueA.equals(valueB);
    }

    public static boolean datesEqual(Date dateA, Date dateB) {
        if (dateA == null && dateB == null) {
            return true;
        }
        if (dateA == null || dateB == null) {
            return false;
        }
        GregorianCalendar calA = new GregorianCalendar();
        calA.setTime(dateA);
        GregorianCalendar calB = new GregorianCalendar();
        calB.setTime(dateB);
        return calA.get(5) == calB.get(5) && calA.get(2) == calB.get(2) && calA.get(1) == calB.get(1);
    }

    public static int compare(String objectA, String objectB) {
        if (objectA == objectB) {
            return 0;
        }
        int result = BeanUtils.compareForNull(objectA, objectB);
        return result != 0 ? result : objectA.compareTo(objectB);
    }

    private static int compareForNull(Object objectA, Object objectB) {
        if (objectA == null && objectB != null) {
            return 1;
        }
        if (objectA != null && objectB == null) {
            return -1;
        }
        return 0;
    }

    @SafeVarargs
    public static <T> T[] addToArray(T[] array, T ... items) {
        ArrayList<T> list = new ArrayList<T>(Arrays.asList(array));
        Collections.addAll(list, items);
        Class<?> type = array.getClass().getComponentType();
        return ReflectUtils.toArray(type, list);
    }

    @SafeVarargs
    public static <T> T[] removeFromArray(T[] array, T ... items) {
        ArrayList<T> list = new ArrayList<T>(Arrays.asList(array));
        for (T item : items) {
            list.remove(item);
        }
        Class<?> type = array.getClass().getComponentType();
        return ReflectUtils.toArray(type, list);
    }

    @SafeVarargs
    public static <T> T[] replaceInArray(T[] array, T ... items) {
        array = BeanUtils.removeFromArray(array, items);
        array = BeanUtils.addToArray(array, items);
        return array;
    }

    public static Map<String, String> toMap(String ... keyValuePairs) {
        if (keyValuePairs == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String pair : keyValuePairs) {
            int pos;
            int n = pos = pair == null ? -1 : pair.indexOf(":");
            if (pair == null) {
                map.put(null, null);
                continue;
            }
            if (pos < 0) {
                map.put(pair, null);
                continue;
            }
            String key = pair.substring(0, pos);
            String value = pair.substring(pos + 1);
            map.put(key, value);
        }
        return map;
    }
}

