/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.common.fine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.crazyyak.dev.common.fine.FineMessage;
import org.crazyyak.dev.common.fine.FineMessageSet;
import org.crazyyak.dev.common.fine.TraitMap;

public class ImmutableFineMessageSet
implements FineMessageSet,
Iterable<FineMessage>,
Serializable {
    private static final ImmutableFineMessageSet emptySet = new ImmutableFineMessageSet(new FineMessage[0]);
    private final List<FineMessage> messages;

    public static ImmutableFineMessageSet empty() {
        return emptySet;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ImmutableFineMessageSet(FineMessage ... messages) {
        this(Arrays.asList(messages));
    }

    public ImmutableFineMessageSet(Collection<FineMessage> messages) {
        ArrayList<FineMessage> mutableList = new ArrayList<FineMessage>(messages);
        this.messages = Collections.unmodifiableList(mutableList);
    }

    @Override
    public boolean hasText(String text) {
        for (FineMessage message : this.messages) {
            if (!message.isText(text)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasId(String id) {
        for (FineMessage message : this.messages) {
            if (!message.isId(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public FineMessage findFirstWithId(String id) {
        for (FineMessage message : this.messages) {
            if (!message.isId(id)) continue;
            return message;
        }
        return null;
    }

    public List<FineMessage> findWithId(String id) {
        ArrayList<FineMessage> foundList = new ArrayList<FineMessage>();
        for (FineMessage message : this.messages) {
            if (!message.isId(id)) continue;
            foundList.add(message);
        }
        return foundList;
    }

    @Override
    public FineMessage findFirstWithTrait(String trait) {
        for (FineMessage message : this.messages) {
            if (!message.hasTrait(trait)) continue;
            return message;
        }
        return null;
    }

    @Override
    public FineMessageSet findWithTrait(String trait) {
        ArrayList<FineMessage> foundList = new ArrayList<FineMessage>();
        for (FineMessage message : this.messages) {
            if (!message.hasTrait(trait)) continue;
            foundList.add(message);
        }
        return new ImmutableFineMessageSet(foundList);
    }

    @Override
    public String getDisplay() {
        StringBuilder sb = new StringBuilder();
        for (FineMessage message : this.messages) {
            sb.append(message.getDisplay());
            sb.append("\n");
        }
        if (sb.length() > 2) {
            sb.delete(sb.length() - 2, sb.length());
        }
        return sb.toString();
    }

    @Override
    public String getText() {
        StringBuilder sb = new StringBuilder();
        for (FineMessage message : this.messages) {
            sb.append(message.getDisplay());
            sb.append(" ");
        }
        if (sb.length() > 2) {
            sb.delete(sb.length() - 2, sb.length());
        }
        return sb.toString();
    }

    @Override
    public String getSummary() {
        if (this.isEmpty()) {
            return String.format("%s is empty.", this.getClass().getSimpleName());
        }
        StringBuilder text = new StringBuilder();
        for (FineMessage message : this.getMessages()) {
            text.append(message.getText());
            text.append(", ");
        }
        return text.substring(0, Math.max(text.length() - 2, 0));
    }

    @Override
    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    @Override
    public boolean isNotEmpty() {
        return !this.messages.isEmpty();
    }

    @Override
    public int size() {
        return this.messages.size();
    }

    @Override
    public Iterator<FineMessage> iterator() {
        return this.messages.iterator();
    }

    public List<FineMessage> getMessages() {
        return this.messages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableFineMessageSet that = (ImmutableFineMessageSet)o;
        return this.messages.equals(that.messages);
    }

    public int hashCode() {
        return this.messages.hashCode();
    }

    public String toString() {
        return this.getDisplay();
    }

    public static class Builder {
        private final List<FineMessage> messages = new ArrayList<FineMessage>();

        public ImmutableFineMessageSet build() {
            return new ImmutableFineMessageSet(this.messages);
        }

        public Builder withMessage(FineMessage message) {
            if (message instanceof FineMessage) {
                this.messages.add(message);
            } else {
                this.messages.add(FineMessage.withAll(message.getText(), message.getId(), message.getTraitMap()));
            }
            return this;
        }

        public Builder withText(String text) {
            this.messages.add(FineMessage.withAll(text, null, TraitMap.empty()));
            return this;
        }

        public Builder withId(String text, String id) {
            this.messages.add(FineMessage.withAll(text, id, TraitMap.empty()));
            return this;
        }

        public Builder withTraits(String text, TraitMap traitMap) {
            this.messages.add(FineMessage.withAll(text, null, traitMap));
            return this;
        }

        public Builder withTraits(String text, Map<String, String> traitMapArg) {
            TraitMap traitMap = traitMapArg != null && traitMapArg.size() > 0 ? new TraitMap(traitMapArg) : TraitMap.empty();
            this.messages.add(FineMessage.withAll(text, null, traitMap));
            return this;
        }

        public Builder withTraits(String text, String ... traits) {
            TraitMap traitMap = traits != null && traits.length > 0 ? new TraitMap(traits) : TraitMap.empty();
            this.messages.add(FineMessage.withAll(text, null, traitMap));
            return this;
        }

        public Builder withAll(String text, String id, TraitMap traitMap) {
            this.messages.add(FineMessage.withAll(text, id, traitMap));
            return this;
        }

        public Builder withSet(FineMessageSet fineMsgSet) {
            if (fineMsgSet instanceof ImmutableFineMessageSet) {
                return this.withSet(fineMsgSet);
            }
            for (FineMessage fineMessage : fineMsgSet.getMessages()) {
                this.withMessage(fineMessage);
            }
            return this;
        }

        public Builder withImmutableSet(ImmutableFineMessageSet fineMsgSet) {
            if (fineMsgSet != null) {
                this.messages.addAll(fineMsgSet.getMessages());
            }
            return this;
        }
    }
}

