package org.crazyyak.dev.common.fine;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
* Created by jacobp on 7/29/2014.
*/
public class ImmutableFineMessageSetBuilder {

  private final List<FineMessage> messages = new ArrayList<>();

  public ImmutableFineMessageSet build() {
    return new ImmutableFineMessageSet(messages);
  }

  public ImmutableFineMessageSetBuilder withMessage(FineMessage message) {
    if (message instanceof FineMessage) {
      messages.add((FineMessage)message);
    } else {
      this.messages.add(FineMessage.withAll(
          message.getText(),
          message.getId(),
          message.getTraitMap()));
    }
    return this;
  }

  public ImmutableFineMessageSetBuilder withText(String text) {
    messages.add(FineMessage.withAll(text, null, TraitMap.empty()));
    return this;
  }

  public ImmutableFineMessageSetBuilder withId(String text, String id) {
    messages.add(FineMessage.withAll(text, id, TraitMap.empty()));
    return this;
  }

  public ImmutableFineMessageSetBuilder withTraits(String text, TraitMap traitMap) {
    messages.add(FineMessage.withAll(text, null, traitMap));
    return this;
  }

  public ImmutableFineMessageSetBuilder withTraits(String text, Map<String, String> traitMapArg) {
    TraitMap traitMap = (traitMapArg != null && traitMapArg.size() > 0) ? new TraitMap(traitMapArg) : TraitMap.empty();
    messages.add(FineMessage.withAll(text, null, traitMap));
    return this;
  }

  public ImmutableFineMessageSetBuilder withTraits(String text, String...traits) {
    TraitMap traitMap = (traits != null && traits.length > 0) ? new TraitMap(traits) : TraitMap.empty();
    messages.add(FineMessage.withAll(text, null, traitMap));
    return this;
  }

  public ImmutableFineMessageSetBuilder withAll(String text, String id, TraitMap traitMap) {
    messages.add(FineMessage.withAll(text, id, traitMap));
    return this;
  }

  public ImmutableFineMessageSetBuilder withSet(FineMessageSet fineMsgSet) {
    if (fineMsgSet instanceof ImmutableFineMessageSet) {
      return withSet(fineMsgSet);
    }

    for (FineMessage message : fineMsgSet.getMessages()) {
      this.withMessage(message);
    }

    return this;
  }

  public ImmutableFineMessageSetBuilder withImmutableSet(ImmutableFineMessageSet fineMsgSet) {
    if (fineMsgSet != null) {
      this.messages.addAll(fineMsgSet.getMessages());
    }
    return this;
  }
}
