/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.common.fine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.crazyyak.dev.common.fine.FineMessage;
import org.crazyyak.dev.common.fine.FineMessageSet;
import org.crazyyak.dev.common.fine.ImmutableFineMessageSetBuilder;

public class ImmutableFineMessageSet
implements FineMessageSet,
Iterable<FineMessage>,
Serializable {
    private static final ImmutableFineMessageSet emptySet = new ImmutableFineMessageSet();
    private final List<FineMessage> messages;

    public static ImmutableFineMessageSet empty() {
        return emptySet;
    }

    public static ImmutableFineMessageSetBuilder builder() {
        return new ImmutableFineMessageSetBuilder();
    }

    public ImmutableFineMessageSet() {
        this(Collections.emptySet());
    }

    public ImmutableFineMessageSet(FineMessage ... messages) {
        this(Arrays.asList(messages));
    }

    public ImmutableFineMessageSet(FineMessageSet messageSet) {
        this(messageSet.getMessages());
    }

    public ImmutableFineMessageSet(Collection<? extends FineMessage> messages) {
        ArrayList<? extends FineMessage> mutableList = new ArrayList<FineMessage>(messages);
        this.messages = Collections.unmodifiableList(mutableList);
    }

    @Override
    public boolean hasText(String text) {
        for (FineMessage message : this.messages) {
            if (!message.isText(text)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasId(String id) {
        for (FineMessage message : this.messages) {
            if (!message.isId(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public FineMessage findFirstWithId(String id) {
        for (FineMessage message : this.messages) {
            if (!message.isId(id)) continue;
            return message;
        }
        return null;
    }

    @Override
    public FineMessageSet findWithId(String id) {
        ArrayList<FineMessage> foundList = new ArrayList<FineMessage>();
        for (FineMessage message : this.messages) {
            if (!message.isId(id)) continue;
            foundList.add(message);
        }
        return new ImmutableFineMessageSet(foundList);
    }

    @Override
    public FineMessage findFirstWithTrait(String trait) {
        for (FineMessage message : this.messages) {
            if (!message.hasTrait(trait)) continue;
            return message;
        }
        return null;
    }

    @Override
    public FineMessageSet findWithTrait(String trait) {
        ArrayList<FineMessage> foundList = new ArrayList<FineMessage>();
        for (FineMessage message : this.messages) {
            if (!message.hasTrait(trait)) continue;
            foundList.add(message);
        }
        return new ImmutableFineMessageSet(foundList);
    }

    @Override
    public String toString(String deliminator) {
        if (this.isEmpty()) {
            return String.format("%s is empty.", this.getClass().getSimpleName());
        }
        StringBuilder text = new StringBuilder();
        for (FineMessage message : this.messages) {
            text.append(message.getText());
            text.append(deliminator);
        }
        int length = text.length() - deliminator.length();
        return text.substring(0, Math.max(length, 0));
    }

    @Override
    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    @Override
    public boolean isNotEmpty() {
        return !this.messages.isEmpty();
    }

    @Override
    public int size() {
        return this.messages.size();
    }

    @Override
    public Iterator<FineMessage> iterator() {
        return this.messages.iterator();
    }

    public List<FineMessage> getMessages() {
        return this.messages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableFineMessageSet that = (ImmutableFineMessageSet)o;
        return this.messages.equals(that.messages);
    }

    public int hashCode() {
        return this.messages.hashCode();
    }

    public String toString() {
        return this.toString(", ");
    }
}

