/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.common.fine;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.crazyyak.dev.common.fine.FineMessage;
import org.crazyyak.dev.common.fine.FineMessageSet;
import org.crazyyak.dev.common.fine.ImmutableFineMessageSet;
import org.crazyyak.dev.common.fine.TraitMap;

public class ImmutableFineMessageSetBuilder {
    private final List<FineMessage> messages = new ArrayList<FineMessage>();

    public ImmutableFineMessageSet build() {
        return new ImmutableFineMessageSet(this.messages);
    }

    public ImmutableFineMessageSetBuilder withMessage(FineMessage message) {
        if (message instanceof FineMessage) {
            this.messages.add(message);
        } else {
            this.messages.add(FineMessage.withAll(message.getText(), message.getId(), message.getTraitMap()));
        }
        return this;
    }

    public ImmutableFineMessageSetBuilder withText(String text) {
        this.messages.add(FineMessage.withAll(text, null, TraitMap.empty()));
        return this;
    }

    public ImmutableFineMessageSetBuilder withId(String text, String id) {
        this.messages.add(FineMessage.withAll(text, id, TraitMap.empty()));
        return this;
    }

    public ImmutableFineMessageSetBuilder withTraits(String text, TraitMap traitMap) {
        this.messages.add(FineMessage.withAll(text, null, traitMap));
        return this;
    }

    public ImmutableFineMessageSetBuilder withTraits(String text, Map<String, String> traitMapArg) {
        TraitMap traitMap = traitMapArg != null && traitMapArg.size() > 0 ? new TraitMap(traitMapArg) : TraitMap.empty();
        this.messages.add(FineMessage.withAll(text, null, traitMap));
        return this;
    }

    public ImmutableFineMessageSetBuilder withTraits(String text, String ... traits) {
        TraitMap traitMap = traits != null && traits.length > 0 ? new TraitMap(traits) : TraitMap.empty();
        this.messages.add(FineMessage.withAll(text, null, traitMap));
        return this;
    }

    public ImmutableFineMessageSetBuilder withAll(String text, String id, TraitMap traitMap) {
        this.messages.add(FineMessage.withAll(text, id, traitMap));
        return this;
    }

    public ImmutableFineMessageSetBuilder withSet(FineMessageSet fineMsgSet) {
        if (fineMsgSet instanceof ImmutableFineMessageSet) {
            return this.withSet(fineMsgSet);
        }
        for (FineMessage fineMessage : fineMsgSet.getMessages()) {
            this.withMessage(fineMessage);
        }
        return this;
    }

    public ImmutableFineMessageSetBuilder withImmutableSet(ImmutableFineMessageSet fineMsgSet) {
        if (fineMsgSet != null) {
            this.messages.addAll(fineMsgSet.getMessages());
        }
        return this;
    }
}

