/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.common.exceptions;

import org.crazyyak.dev.common.exceptions.FineRuntimeException;
import org.crazyyak.dev.common.fine.FineMessage;
import org.crazyyak.dev.common.fine.FineMessageSet;
import org.crazyyak.dev.common.net.HttpStatusCode;

public class ApiException
extends FineRuntimeException {
    private final HttpStatusCode httpStatusCode;

    public ApiException(HttpStatusCode httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    public ApiException(HttpStatusCode httpStatusCode, String message, String ... traits) {
        super(message, traits);
        this.httpStatusCode = httpStatusCode;
    }

    public ApiException(HttpStatusCode httpStatusCode, Throwable ex, String ... traits) {
        super(ex, traits);
        this.httpStatusCode = httpStatusCode;
    }

    public ApiException(HttpStatusCode httpStatusCode, String message, Throwable ex, String ... traits) {
        super(message, ex, traits);
        this.httpStatusCode = httpStatusCode;
    }

    public ApiException(HttpStatusCode httpStatusCode, FineMessage richMessage) {
        super(richMessage);
        this.httpStatusCode = httpStatusCode;
    }

    public ApiException(HttpStatusCode httpStatusCode, FineMessage richMessage, String message) {
        super(richMessage, message);
        this.httpStatusCode = httpStatusCode;
    }

    public ApiException(HttpStatusCode httpStatusCode, FineMessage richMessage, Throwable ex) {
        super(richMessage, ex);
        this.httpStatusCode = httpStatusCode;
    }

    public ApiException(HttpStatusCode httpStatusCode, FineMessage richMessage, String message, Throwable ex) {
        super(richMessage, message, ex);
        this.httpStatusCode = httpStatusCode;
    }

    public ApiException(HttpStatusCode httpStatusCode, FineMessageSet messageSet) {
        super(messageSet);
        this.httpStatusCode = httpStatusCode;
    }

    public ApiException(HttpStatusCode httpStatusCode, FineMessageSet messageSet, String message) {
        super(messageSet, message);
        this.httpStatusCode = httpStatusCode;
    }

    public ApiException(HttpStatusCode httpStatusCode, FineMessageSet messageSet, Throwable ex) {
        super(messageSet, ex);
        this.httpStatusCode = httpStatusCode;
    }

    public ApiException(HttpStatusCode httpStatusCode, FineMessageSet messageSet, String message, Throwable ex) {
        super(messageSet, message, ex);
        this.httpStatusCode = httpStatusCode;
    }

    public int getStatusCode() {
        return this.httpStatusCode == null ? -1 : this.httpStatusCode.getCode();
    }

    public HttpStatusCode getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public static ApiException forbidden() {
        return new ApiException(HttpStatusCode.FORBIDDEN);
    }

    public static ApiException forbidden(String message, String ... traits) {
        return new ApiException(HttpStatusCode.FORBIDDEN, message, traits);
    }

    public static ApiException forbidden(Throwable ex, String ... traits) {
        return new ApiException(HttpStatusCode.FORBIDDEN, ex, traits);
    }

    public static ApiException forbidden(String message, Throwable ex, String ... traits) {
        return new ApiException(HttpStatusCode.FORBIDDEN, message, ex, traits);
    }

    public static ApiException forbidden(FineMessage richMessage) {
        return new ApiException(HttpStatusCode.FORBIDDEN, richMessage);
    }

    public static ApiException forbidden(FineMessage richMessage, String message) {
        return new ApiException(HttpStatusCode.FORBIDDEN, richMessage, message);
    }

    public static ApiException forbidden(FineMessage richMessage, Throwable ex) {
        return new ApiException(HttpStatusCode.FORBIDDEN, richMessage, ex);
    }

    public static ApiException forbidden(FineMessage richMessage, String message, Throwable ex) {
        return new ApiException(HttpStatusCode.FORBIDDEN, richMessage, message, ex);
    }

    public static ApiException forbidden(FineMessageSet messageSet) {
        return new ApiException(HttpStatusCode.FORBIDDEN, messageSet);
    }

    public static ApiException forbidden(FineMessageSet messageSet, String message) {
        return new ApiException(HttpStatusCode.FORBIDDEN, messageSet, message);
    }

    public static ApiException forbidden(FineMessageSet messageSet, Throwable ex) {
        return new ApiException(HttpStatusCode.FORBIDDEN, messageSet, ex);
    }

    public static ApiException forbidden(FineMessageSet messageSet, String message, Throwable ex) {
        return new ApiException(HttpStatusCode.FORBIDDEN, messageSet, message, ex);
    }

    public static ApiException conflict() {
        return new ApiException(HttpStatusCode.CONFLICT);
    }

    public static ApiException conflict(String message, String ... traits) {
        return new ApiException(HttpStatusCode.CONFLICT, message, traits);
    }

    public static ApiException conflict(Throwable ex, String ... traits) {
        return new ApiException(HttpStatusCode.CONFLICT, ex, traits);
    }

    public static ApiException conflict(String message, Throwable ex, String ... traits) {
        return new ApiException(HttpStatusCode.CONFLICT, message, ex, traits);
    }

    public static ApiException conflict(FineMessage richMessage) {
        return new ApiException(HttpStatusCode.CONFLICT, richMessage);
    }

    public static ApiException conflict(FineMessage richMessage, String message) {
        return new ApiException(HttpStatusCode.CONFLICT, richMessage, message);
    }

    public static ApiException conflict(FineMessage richMessage, Throwable ex) {
        return new ApiException(HttpStatusCode.CONFLICT, richMessage, ex);
    }

    public static ApiException conflict(FineMessage richMessage, String message, Throwable ex) {
        return new ApiException(HttpStatusCode.CONFLICT, richMessage, message, ex);
    }

    public static ApiException conflict(FineMessageSet messageSet) {
        return new ApiException(HttpStatusCode.CONFLICT, messageSet);
    }

    public static ApiException conflict(FineMessageSet messageSet, String message) {
        return new ApiException(HttpStatusCode.CONFLICT, messageSet, message);
    }

    public static ApiException conflict(FineMessageSet messageSet, Throwable ex) {
        return new ApiException(HttpStatusCode.CONFLICT, messageSet, ex);
    }

    public static ApiException conflict(FineMessageSet messageSet, String message, Throwable ex) {
        return new ApiException(HttpStatusCode.CONFLICT, messageSet, message, ex);
    }

    public static ApiException notFound() {
        return new ApiException(HttpStatusCode.NOT_FOUND);
    }

    public static ApiException notFound(String message, String ... traits) {
        return new ApiException(HttpStatusCode.NOT_FOUND, message, traits);
    }

    public static ApiException notFound(Throwable ex, String ... traits) {
        return new ApiException(HttpStatusCode.NOT_FOUND, ex, traits);
    }

    public static ApiException notFound(String message, Throwable ex, String ... traits) {
        return new ApiException(HttpStatusCode.NOT_FOUND, message, ex, traits);
    }

    public static ApiException notFound(FineMessage richMessage) {
        return new ApiException(HttpStatusCode.NOT_FOUND, richMessage);
    }

    public static ApiException notFound(FineMessage richMessage, String message) {
        return new ApiException(HttpStatusCode.NOT_FOUND, richMessage, message);
    }

    public static ApiException notFound(FineMessage richMessage, Throwable ex) {
        return new ApiException(HttpStatusCode.NOT_FOUND, richMessage, ex);
    }

    public static ApiException notFound(FineMessage richMessage, String message, Throwable ex) {
        return new ApiException(HttpStatusCode.NOT_FOUND, richMessage, message, ex);
    }

    public static ApiException notFound(FineMessageSet messageSet) {
        return new ApiException(HttpStatusCode.NOT_FOUND, messageSet);
    }

    public static ApiException notFound(FineMessageSet messageSet, String message) {
        return new ApiException(HttpStatusCode.NOT_FOUND, messageSet, message);
    }

    public static ApiException notFound(FineMessageSet messageSet, Throwable ex) {
        return new ApiException(HttpStatusCode.NOT_FOUND, messageSet, ex);
    }

    public static ApiException notFound(FineMessageSet messageSet, String message, Throwable ex) {
        return new ApiException(HttpStatusCode.NOT_FOUND, messageSet, message, ex);
    }

    public static ApiException badRequest() {
        return new ApiException(HttpStatusCode.BAD_REQUEST);
    }

    public static ApiException badRequest(String message, String ... traits) {
        return new ApiException(HttpStatusCode.BAD_REQUEST, message, traits);
    }

    public static ApiException badRequest(Throwable ex, String ... traits) {
        return new ApiException(HttpStatusCode.BAD_REQUEST, ex, traits);
    }

    public static ApiException badRequest(String message, Throwable ex, String ... traits) {
        return new ApiException(HttpStatusCode.BAD_REQUEST, message, ex, traits);
    }

    public static ApiException badRequest(FineMessage richMessage) {
        return new ApiException(HttpStatusCode.BAD_REQUEST, richMessage);
    }

    public static ApiException badRequest(FineMessage richMessage, String message) {
        return new ApiException(HttpStatusCode.BAD_REQUEST, richMessage, message);
    }

    public static ApiException badRequest(FineMessage richMessage, Throwable ex) {
        return new ApiException(HttpStatusCode.BAD_REQUEST, richMessage, ex);
    }

    public static ApiException badRequest(FineMessage richMessage, String message, Throwable ex) {
        return new ApiException(HttpStatusCode.BAD_REQUEST, richMessage, message, ex);
    }

    public static ApiException badRequest(FineMessageSet messageSet) {
        return new ApiException(HttpStatusCode.BAD_REQUEST, messageSet);
    }

    public static ApiException badRequest(FineMessageSet messageSet, String message) {
        return new ApiException(HttpStatusCode.BAD_REQUEST, messageSet, message);
    }

    public static ApiException badRequest(FineMessageSet messageSet, Throwable ex) {
        return new ApiException(HttpStatusCode.BAD_REQUEST, messageSet, ex);
    }

    public static ApiException badRequest(FineMessageSet messageSet, String message, Throwable ex) {
        return new ApiException(HttpStatusCode.BAD_REQUEST, messageSet, message, ex);
    }

    public static ApiException internalServerError() {
        return new ApiException(HttpStatusCode.INTERNAL_SERVER_ERROR);
    }

    public static ApiException internalServerError(String message, String ... traits) {
        return new ApiException(HttpStatusCode.INTERNAL_SERVER_ERROR, message, traits);
    }

    public static ApiException internalServerError(Throwable ex, String ... traits) {
        return new ApiException(HttpStatusCode.INTERNAL_SERVER_ERROR, ex, traits);
    }

    public static ApiException internalServerError(String message, Throwable ex, String ... traits) {
        return new ApiException(HttpStatusCode.INTERNAL_SERVER_ERROR, message, ex, traits);
    }

    public static ApiException internalServerError(FineMessage richMessage) {
        return new ApiException(HttpStatusCode.INTERNAL_SERVER_ERROR, richMessage);
    }

    public static ApiException internalServerError(FineMessage richMessage, String message) {
        return new ApiException(HttpStatusCode.INTERNAL_SERVER_ERROR, richMessage, message);
    }

    public static ApiException internalServerError(FineMessage richMessage, Throwable ex) {
        return new ApiException(HttpStatusCode.INTERNAL_SERVER_ERROR, richMessage, ex);
    }

    public static ApiException internalServerError(FineMessage richMessage, String message, Throwable ex) {
        return new ApiException(HttpStatusCode.INTERNAL_SERVER_ERROR, richMessage, message, ex);
    }

    public static ApiException internalServerError(FineMessageSet messageSet) {
        return new ApiException(HttpStatusCode.INTERNAL_SERVER_ERROR, messageSet);
    }

    public static ApiException internalServerError(FineMessageSet messageSet, String message) {
        return new ApiException(HttpStatusCode.INTERNAL_SERVER_ERROR, messageSet, message);
    }

    public static ApiException internalServerError(FineMessageSet messageSet, Throwable ex) {
        return new ApiException(HttpStatusCode.INTERNAL_SERVER_ERROR, messageSet, ex);
    }

    public static ApiException internalServerError(FineMessageSet messageSet, String message, Throwable ex) {
        return new ApiException(HttpStatusCode.INTERNAL_SERVER_ERROR, messageSet, message, ex);
    }

    public static ApiException serviceUnavailable() {
        return new ApiException(HttpStatusCode.SERVICE_UNAVAILABLE);
    }

    public static ApiException serviceUnavailable(String message, String ... traits) {
        return new ApiException(HttpStatusCode.SERVICE_UNAVAILABLE, message, traits);
    }

    public static ApiException serviceUnavailable(Throwable ex, String ... traits) {
        return new ApiException(HttpStatusCode.SERVICE_UNAVAILABLE, ex, traits);
    }

    public static ApiException serviceUnavailable(String message, Throwable ex, String ... traits) {
        return new ApiException(HttpStatusCode.SERVICE_UNAVAILABLE, message, ex, traits);
    }

    public static ApiException serviceUnavailable(FineMessage richMessage) {
        return new ApiException(HttpStatusCode.SERVICE_UNAVAILABLE, richMessage);
    }

    public static ApiException serviceUnavailable(FineMessage richMessage, String message) {
        return new ApiException(HttpStatusCode.SERVICE_UNAVAILABLE, richMessage, message);
    }

    public static ApiException serviceUnavailable(FineMessage richMessage, Throwable ex) {
        return new ApiException(HttpStatusCode.SERVICE_UNAVAILABLE, richMessage, ex);
    }

    public static ApiException serviceUnavailable(FineMessage richMessage, String message, Throwable ex) {
        return new ApiException(HttpStatusCode.SERVICE_UNAVAILABLE, richMessage, message, ex);
    }

    public static ApiException serviceUnavailable(FineMessageSet messageSet) {
        return new ApiException(HttpStatusCode.SERVICE_UNAVAILABLE, messageSet);
    }

    public static ApiException serviceUnavailable(FineMessageSet messageSet, String message) {
        return new ApiException(HttpStatusCode.SERVICE_UNAVAILABLE, messageSet, message);
    }

    public static ApiException serviceUnavailable(FineMessageSet messageSet, Throwable ex) {
        return new ApiException(HttpStatusCode.SERVICE_UNAVAILABLE, messageSet, ex);
    }

    public static ApiException serviceUnavailable(FineMessageSet messageSet, String message, Throwable ex) {
        return new ApiException(HttpStatusCode.SERVICE_UNAVAILABLE, messageSet, message, ex);
    }
}

