package org.crazyyak.dev.common.rest;

import java.util.Map;

public interface RestClient {

  void post(String subUrl);
  void post(String subUrl, Object entity);

  <T> T post(Class returnType, String subUrl);
  <T> T post(Class returnType, String subUrl, Object entity);

  <T> T get(Class returnType, String subUrl, String...queryParams);
  <T> T get(Class returnType, String subUrl, Map<String,Object> queryParams);
  <T> T get(Class returnType, String subUrl, Map<String, Object> queryParams, String...acceptedResponseTypes);

  <T> T getPlainText(String subUrl, String...queryParams);
  <T> T getPlainText(String subUrl, Map<String,Object> queryParams);

  String getApiUrl();
  String getUserName();
  String getPassword();
}
