/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.common;

import java.util.Calendar;
import java.util.Date;
import org.crazyyak.dev.common.exceptions.ExceptionUtils;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

public class DateUtils {
    private DateUtils() {
    }

    public static LocalTime currentTime() {
        return new LocalTime();
    }

    public static LocalDateTime currentDateTime() {
        return new LocalDateTime();
    }

    public static LocalDate currentDate() {
        return new LocalDate();
    }

    public static LocalDateTime midnightToday() {
        return new LocalDate().toLocalDateTime(LocalTime.MIDNIGHT);
    }

    public static LocalDate toLocalDate(String date) {
        return DateUtils.toDateTime(date).toLocalDate();
    }

    public static LocalDate toLocalDate(long date) {
        return DateUtils.toDateTime(date).toLocalDate();
    }

    public static LocalDate toLocalDate(Date date) {
        return DateUtils.toDateTime(date).toLocalDate();
    }

    public static LocalDate toLocalDate(Calendar date) {
        return DateUtils.toDateTime(date).toLocalDate();
    }

    public static LocalDate toLocalDate(LocalDateTime date) {
        return DateUtils.toDateTime(date).toLocalDate();
    }

    public static LocalDate toLocalDate(DateTime date) {
        return ExceptionUtils.assertNotNull(date, "date").toLocalDate();
    }

    public static LocalTime toLocalTime(String date) {
        return DateUtils.toDateTime(date).toLocalTime();
    }

    public static LocalTime toLocalTime(long date) {
        return DateUtils.toDateTime(date).toLocalTime();
    }

    public static LocalTime toLocalTime(Date date) {
        return DateUtils.toDateTime(date).toLocalTime();
    }

    public static LocalTime toLocalTime(Calendar date) {
        return DateUtils.toDateTime(date).toLocalTime();
    }

    public static LocalTime toLocalTime(LocalDateTime date) {
        return DateUtils.toDateTime(date).toLocalTime();
    }

    public static LocalTime toLocalTime(DateTime date) {
        return ExceptionUtils.assertNotNull(date, "date").toLocalTime();
    }

    public static LocalDateTime toLocalDateTime(String date) {
        return DateUtils.toDateTime(date).toLocalDateTime();
    }

    public static LocalDateTime toLocalDateTime(long date) {
        return DateUtils.toDateTime(date).toLocalDateTime();
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return DateUtils.toDateTime(date).toLocalDateTime();
    }

    public static LocalDateTime toLocalDateTime(Calendar date) {
        return DateUtils.toDateTime(date).toLocalDateTime();
    }

    public static LocalDateTime toLocalDateTime(LocalDate date) {
        return DateUtils.toDateTime(date).toLocalDateTime();
    }

    public static LocalDateTime toLocalDateTime(DateTime date) {
        return ExceptionUtils.assertNotNull(date, "date").toLocalDateTime();
    }

    public static DateTime toDateTime(String stringDate) {
        ExceptionUtils.assertNotNull(stringDate, "stringDate");
        if (stringDate.contains(" ")) {
            stringDate = stringDate.replace(" ", "T");
            return new DateTime((Object)stringDate);
        }
        if (stringDate.contains("T")) {
            return new DateTime((Object)stringDate);
        }
        return new LocalDate((Object)stringDate).toDateTime(LocalTime.MIDNIGHT);
    }

    public static DateTime toDateTime(long date) {
        if (date == 0L) {
            throw new IllegalArgumentException("The value \"date\" must be greater than zero.");
        }
        return new DateTime(date);
    }

    public static DateTime toDateTime(LocalDate date) {
        ExceptionUtils.assertNotNull(date, "date");
        return date.toDateTime(LocalTime.MIDNIGHT);
    }

    public static DateTime toDateTime(LocalDateTime date) {
        ExceptionUtils.assertNotNull(date, "date");
        return date.toDateTime();
    }

    public static DateTime toDateTime(Date date) {
        ExceptionUtils.assertNotNull(date, "date");
        return new DateTime(date.getTime());
    }

    public static DateTime toDateTime(Calendar date) {
        ExceptionUtils.assertNotNull(date, "date");
        return new DateTime(date.getTime().getTime());
    }
}

