/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.common;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import org.crazyyak.dev.common.io.FileNameFilter;

public class IoUtils {
    public static String toString(URL url) throws IOException {
        try {
            return IoUtils.toString(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public static String toString(URI uri) throws IOException {
        File file = new File(uri);
        return IoUtils.toString(file);
    }

    public static String toString(Exception e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    public static String toString(File file) throws IOException {
        return IoUtils.toString(new FileReader(file));
    }

    public static String toString(InputStream is) throws IOException {
        return IoUtils.toString(new BufferedReader(new InputStreamReader(is)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Reader reader) throws IOException {
        try {
            BufferedReader bufferedReader;
            String line = "";
            StringBuilder builder = new StringBuilder();
            BufferedReader bufferedReader2 = bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            while ((line = bufferedReader.readLine()) != null) {
                builder.append(line);
                builder.append("\n");
            }
            String string = builder.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static void toFile(InputStream inputStream, File file) throws IOException {
        IoUtils.deleteFile(file);
        FileOutputStream out = new FileOutputStream(file);
        IoUtils.toStream(inputStream, out);
    }

    public static byte[] toBytes(InputStream in) throws IOException {
        return IoUtils.toBytes(in, 1024);
    }

    public static byte[] toBytes(InputStream in, int initCapacity) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(initCapacity);
        IoUtils.toStream(in, out);
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toStream(InputStream in, OutputStream out) throws IOException {
        try {
            int count;
            byte[] buf = new byte[1024];
            while ((count = in.read(buf)) != -1) {
                if (Thread.interrupted()) {
                    throw new IOException("Thread was interrupted.");
                }
                out.write(buf, 0, count);
            }
        }
        finally {
            out.close();
            in.close();
        }
    }

    public static void write(File file, String result) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            writer.write(result);
        }
    }

    public static void write(File file, byte[] bytes) throws IOException {
        try (FileOutputStream os = new FileOutputStream(file);){
            os.write(bytes);
        }
    }

    public static List<String> toList(File file) throws IOException {
        return IoUtils.toList(new FileReader(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> toList(Reader reader) throws IOException {
        try {
            BufferedReader bufferedReader;
            String line = "";
            ArrayList<String> list = new ArrayList<String>();
            BufferedReader bufferedReader2 = bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            while ((line = bufferedReader.readLine()) != null) {
                list.add(line);
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        finally {
            reader.close();
        }
    }

    public static Path createPath(Path path) throws IOException {
        IoUtils.createPath(path.toFile());
        return path;
    }

    public static File createPath(File file) throws IOException {
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Unable to create directory: " + file.getAbsolutePath());
        }
        return file;
    }

    public static void deleteFile(Path path) throws IOException {
        IoUtils.deleteFile(path.toFile());
    }

    public static void deleteFile(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (!file.delete()) {
            String msg = String.format("Unable to delete the file %s", file.getAbsolutePath());
            throw new IOException(msg);
        }
    }

    public static void deletePath(File file) throws IOException {
        IoUtils.deletePath(file.toPath());
    }

    public static void deletePath(Path path) throws IOException {
        if (!path.toFile().exists()) {
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static File currentDir() {
        return new File(System.getProperty("user.dir"));
    }

    public static File findDirNearCurrent(String dirName) {
        return IoUtils.findDirNear(IoUtils.currentDir(), dirName);
    }

    public static File findDirNear(File startDir, String dirName) {
        if (dirName.equalsIgnoreCase(startDir.getName())) {
            return startDir;
        }
        List<File> dirs = IoUtils.listDirs(startDir, new FileNameFilter(dirName));
        if (!dirs.isEmpty()) {
            return dirs.get(0);
        }
        dirs = IoUtils.listDirs(startDir.getParentFile(), new FileNameFilter(dirName));
        if (!dirs.isEmpty()) {
            return dirs.get(0);
        }
        return null;
    }

    public static List<File> listDirs(File parentDir, FileFilter ... fileFilters) {
        ArrayList<File> dirList = new ArrayList<File>();
        File[] listFiles = null;
        if (parentDir != null && parentDir.exists()) {
            listFiles = parentDir.listFiles();
        }
        if (listFiles != null) {
            for (File file : listFiles) {
                if (!file.isDirectory()) continue;
                boolean accepted = true;
                for (FileFilter filter : fileFilters) {
                    if (filter.accept(file)) continue;
                    accepted = false;
                    break;
                }
                if (!accepted) continue;
                dirList.add(file);
            }
        }
        return dirList;
    }
}

